/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.BatchIterator;
import io.crate.data.Bucket;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.CollectionBucket;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.CollectExpression;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SortingProjector
implements Projector {
    private final Collection<? extends Input<?>> inputs;
    private final Iterable<? extends CollectExpression<Row, ?>> collectExpressions;
    private final Comparator<Object[]> comparator;
    private final int offset;
    private final int numOutputs;
    private final RowAccounting<Object[]> rowAccounting;

    public SortingProjector(RowAccounting<Object[]> rowAccounting, Collection<? extends Input<?>> inputs, Iterable<? extends CollectExpression<Row, ?>> collectExpressions, int numOutputs, Comparator<Object[]> comparator, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset " + offset);
        }
        this.rowAccounting = rowAccounting;
        this.numOutputs = numOutputs;
        this.inputs = inputs;
        this.collectExpressions = collectExpressions;
        this.comparator = comparator;
        this.offset = offset;
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        Collector<Row, ?, Bucket> collector = Collectors.mapping(this::getCells, Collectors.collectingAndThen(Collectors.toList(), this::sortAndCreateBucket));
        return CollectingBatchIterator.newInstance(batchIterator, collector);
    }

    public boolean providesIndependentScroll() {
        return true;
    }

    private Object[] getCells(Row row) {
        for (CollectExpression<Row, ?> collectExpression : this.collectExpressions) {
            collectExpression.setNextRow(row);
        }
        Object[] newRow = new Object[this.inputs.size()];
        int i = 0;
        for (Input<?> input : this.inputs) {
            newRow[i++] = input.value();
        }
        this.rowAccounting.accountForAndMaybeBreak((Object)newRow);
        return newRow;
    }

    private Bucket sortAndCreateBucket(List<Object[]> rows) {
        rows.sort(this.comparator);
        if (this.offset == 0) {
            return new CollectionBucket(rows, this.numOutputs);
        }
        return new CollectionBucket(rows.subList(this.offset, rows.size()), this.numOutputs);
    }
}

