/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.ArrayBucket;
import io.crate.data.Bucket;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.CollectExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.lucene.util.ArrayUtil;

public class UnboundedSortingLimitAndOffsetCollector
implements Collector<Row, PriorityQueue<Object[]>, Bucket> {
    private final Collection<? extends Input<?>> inputs;
    private final Iterable<? extends CollectExpression<Row, ?>> expressions;
    private final int numOutputs;
    private final Comparator<Object[]> comparator;
    private final int initialCapacity;
    private final int offset;
    private final int maxNumberOfRowsInQueue;
    private final RowAccounting<Object[]> rowAccounting;

    public UnboundedSortingLimitAndOffsetCollector(RowAccounting<Object[]> rowAccounting, Collection<? extends Input<?>> inputs, Iterable<? extends CollectExpression<Row, ?>> expressions, int numOutputs, Comparator<Object[]> comparator, int initialCapacity, int limit, int offset) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Invalid initial capacity: value must be > 0; got: " + initialCapacity);
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT: value must be > 0; got: " + limit);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid OFFSET: value must be >= 0; got: " + offset);
        }
        this.rowAccounting = rowAccounting;
        this.inputs = inputs;
        this.expressions = expressions;
        this.numOutputs = numOutputs;
        this.comparator = comparator;
        this.initialCapacity = initialCapacity;
        this.offset = offset;
        this.maxNumberOfRowsInQueue = limit + offset;
        if (this.maxNumberOfRowsInQueue >= ArrayUtil.MAX_ARRAY_LENGTH || this.maxNumberOfRowsInQueue < 0) {
            throw new IllegalArgumentException("Invalid LIMIT + OFFSET: value must be <= " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + this.maxNumberOfRowsInQueue);
        }
    }

    @Override
    public Supplier<PriorityQueue<Object[]>> supplier() {
        return () -> new PriorityQueue<Object[]>(this.initialCapacity, this.comparator.reversed());
    }

    @Override
    public BiConsumer<PriorityQueue<Object[]>, Row> accumulator() {
        return this::onNextRow;
    }

    @Override
    public BinaryOperator<PriorityQueue<Object[]>> combiner() {
        return (pq1, pq2) -> {
            throw new UnsupportedOperationException("combine not supported");
        };
    }

    @Override
    public Function<PriorityQueue<Object[]>, Bucket> finisher() {
        return this::pqToIterable;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private void onNextRow(PriorityQueue<Object[]> pq, Row row) {
        for (CollectExpression<Row, ?> expression : this.expressions) {
            expression.setNextRow(row);
        }
        Object[] rowCells = new Object[this.inputs.size()];
        int i = 0;
        for (Input<?> input : this.inputs) {
            rowCells[i] = input.value();
            ++i;
        }
        this.rowAccounting.accountForAndMaybeBreak((Object)rowCells);
        if (pq.size() == this.maxNumberOfRowsInQueue) {
            Object[] highestElementInOrder = pq.peek();
            if (highestElementInOrder == null || this.comparator.compare(rowCells, highestElementInOrder) < 0) {
                pq.poll();
                pq.add(rowCells);
            }
        } else {
            pq.add(rowCells);
        }
    }

    private Bucket pqToIterable(PriorityQueue<Object[]> pq) {
        if (this.offset > pq.size()) {
            return new ArrayBucket(new Object[0][0], this.numOutputs);
        }
        int resultSize = Math.max(Math.min(this.maxNumberOfRowsInQueue - this.offset, pq.size() - this.offset), 0);
        Object[][] rows = new Object[resultSize][];
        for (int i = resultSize - 1; i >= 0; --i) {
            rows[i] = pq.poll();
        }
        return new ArrayBucket(rows, this.numOutputs);
    }
}

