/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.unit.TimeValue;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class RetryRunnable
implements Runnable,
Scheduler.Cancellable {
    private static final Logger LOGGER = LogManager.getLogger(RetryRunnable.class);
    private final ThreadPool threadPool;
    private final String executorName;
    private final Executor executor;
    private final Iterator<TimeValue> delay;
    private final Runnable retryCommand;
    private volatile Scheduler.Cancellable cancellable;

    public RetryRunnable(ThreadPool threadPool, String executorName, Runnable command, Iterable<TimeValue> backOffPolicy) {
        this.threadPool = threadPool;
        this.executorName = executorName;
        this.executor = threadPool.executor(executorName);
        this.delay = backOffPolicy.iterator();
        this.retryCommand = command;
    }

    @Override
    public void run() {
        try {
            this.executor.execute(this.retryCommand);
        }
        catch (EsRejectedExecutionException e) {
            if (this.delay.hasNext()) {
                long currentDelay = this.delay.next().millis();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received RejectedExecutionException, will retry again in {}ms", (Object)currentDelay);
                }
                this.cancellable = this.threadPool.scheduleUnlessShuttingDown(new TimeValue(currentDelay, TimeUnit.MILLISECONDS), this.executorName, this.retryCommand);
            } else {
                LOGGER.warn("Received RejectedExecutionException after max retries, giving up");
            }
        }
        catch (Exception e) {
            LOGGER.error("Received unhandled exception", (Throwable)e);
        }
    }

    @Override
    public boolean cancel() {
        if (this.cancellable != null) {
            return this.cancellable.cancel();
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this.cancellable != null) {
            return this.cancellable.isCancelled();
        }
        return false;
    }
}

