/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.all;

import io.crate.expression.operator.all.AllOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ComparisonExpression;
import org.apache.lucene.search.Query;

public final class AllRangeOperator
extends AllOperator<Object> {
    private final Comparison comparison;

    AllRangeOperator(Signature signature, BoundSignature boundSignature, Comparison comparison) {
        super(signature, boundSignature);
        this.comparison = comparison;
    }

    @Override
    boolean matches(Object probe, Object candidate) {
        return this.comparison.isMatch(this.leftType.compare(probe, candidate));
    }

    @Override
    protected Query refMatchesAllArrayLiteral(Function all, Reference probe, Literal<?> literal, LuceneQueryBuilder.Context context) {
        return null;
    }

    @Override
    protected Query literalMatchesAllArrayRef(Function all, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        return null;
    }

    public static enum Comparison {
        GT(ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.LESS_THAN){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult > 0;
            }
        }
        ,
        GTE(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult >= 0;
            }
        }
        ,
        LT(ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.GREATER_THAN){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult < 0;
            }
        }
        ,
        LTE(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL){

            @Override
            boolean isMatch(int compareToResult) {
                return compareToResult <= 0;
            }
        };

        private final String innerOpName;
        private final String opName;
        private final String inverseInnerOpName;
        private final String symbol;

        private Comparison(ComparisonExpression.Type cmpExpressionType, ComparisonExpression.Type inverseComparison) {
            this.symbol = cmpExpressionType.getValue();
            this.innerOpName = "op_" + this.symbol;
            this.opName = "_all_" + this.symbol;
            this.inverseInnerOpName = "op_" + inverseComparison.getValue();
        }

        public String opName() {
            return this.opName;
        }

        abstract boolean isMatch(int var1);
    }
}

