/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.expression.operator.LikeOperators;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.RegexpFlag;

public final class AnyNotLikeOperator
extends AnyOperator<String> {
    private final LikeOperators.CaseSensitivity caseSensitivity;

    public AnyNotLikeOperator(Signature signature, BoundSignature boundSignature, LikeOperators.CaseSensitivity caseSensitivity) {
        super(signature, boundSignature);
        this.caseSensitivity = caseSensitivity;
    }

    private static String negateWildcard(String wildCard) {
        return "~(" + wildCard + ")";
    }

    @Override
    boolean matches(String probe, String candidate) {
        return !LikeOperators.matches(probe, candidate, LikeOperators.DEFAULT_ESCAPE, this.caseSensitivity) && !LikeOperators.matches(candidate, probe, LikeOperators.DEFAULT_ESCAPE, this.caseSensitivity);
    }

    @Override
    protected Query refMatchesAnyArrayLiteral(Function any, Reference probe, Literal<?> candidates, LuceneQueryBuilder.Context context) {
        if (ArrayType.dimensions(candidates.valueType()) > 1) {
            return null;
        }
        List<?> nonNullValues = AnyNotLikeOperator.filterNullValues(candidates);
        if (nonNullValues.isEmpty()) {
            return new MatchNoDocsQuery("Cannot match unless there is at least one non-null candidate");
        }
        String columnName = probe.storageIdent();
        BooleanQuery.Builder andLikeQueries = new BooleanQuery.Builder();
        for (Object value : nonNullValues) {
            Query likeQuery = this.caseSensitivity.likeQuery(columnName, (String)value, LikeOperators.DEFAULT_ESCAPE, probe.indexType() != IndexType.NONE);
            if (likeQuery == null) {
                return null;
            }
            andLikeQueries.add(likeQuery, BooleanClause.Occur.MUST);
        }
        return Queries.not((Query)andLikeQueries.build());
    }

    @Override
    protected Query literalMatchesAnyArrayRef(Function any, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        String pattern = (String)probe.value();
        String regexString = LikeOperators.patternToRegex(pattern, LikeOperators.DEFAULT_ESCAPE);
        regexString = regexString.substring(1, regexString.length() - 1);
        String notLike = AnyNotLikeOperator.negateWildcard(regexString);
        return new RegexpQuery(new Term(candidates.storageIdent(), notLike), RegexpFlag.COMPLEMENT.value());
    }

    @Override
    protected void validateRightArg(String arg) {
        if (arg.endsWith("\\")) {
            LikeOperators.throwErrorForTrailingEscapeChar(arg, LikeOperators.DEFAULT_ESCAPE);
        }
    }
}

