/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.predicate;

import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Input;
import io.crate.expression.predicate.IsNullPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public class NotPredicate
extends Scalar<Boolean, Boolean> {
    public static final String NAME = "op_not";
    public static final Signature SIGNATURE = Signature.builder("op_not", FunctionType.SCALAR).argumentTypes(DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build();
    private final NullabilityVisitor INNER_VISITOR = new NullabilityVisitor();

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, NotPredicate::new);
    }

    private NotPredicate(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol != null) : "function must not be null";
        assert (symbol.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = symbol.arguments().get(0);
        if (arg instanceof Input) {
            Object value = ((Input)arg).value();
            if (value == null) {
                return Literal.of(DataTypes.BOOLEAN, null);
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return Literal.of(b == false);
            }
        }
        return symbol;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args.length == 1) : "number of args must be 1";
        Boolean value = (Boolean)args[0].value();
        return value != null ? Boolean.valueOf(value == false) : null;
    }

    @Override
    public Query toQuery(Function input, LuceneQueryBuilder.Context context) {
        Symbol symbol;
        Function innerFunction;
        assert (input != null) : "function must not be null";
        assert (input.arguments().size() == 1) : "function's number of arguments must be 1";
        Symbol arg = input.arguments().get(0);
        if (arg instanceof Function && (innerFunction = (Function)arg).name().equals("op_isnull") && innerFunction.arguments().size() == 1 && (symbol = innerFunction.arguments().get(0)) instanceof Reference) {
            Reference ref = (Reference)symbol;
            if (context.tableInfo().isIgnoredOrImmediateChildOfIgnored(ref)) {
                return null;
            }
            if (!ref.isNullable()) {
                return new MatchAllDocsQuery();
            }
            return IsNullPredicate.refExistsQuery(ref, context);
        }
        Query innerQuery = arg.accept(context.visitor(), context);
        Query notX = Queries.not(innerQuery);
        NullabilityContext ctx = new NullabilityContext();
        arg.accept(this.INNER_VISITOR, ctx);
        if (ctx.enforceThreeValuedLogic()) {
            return new BooleanQuery.Builder().add(notX, BooleanClause.Occur.MUST).add(LuceneQueryBuilder.genericFunctionFilter(input, context), BooleanClause.Occur.FILTER).build();
        }
        if (!ctx.nullableReferences().isEmpty()) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(notX, BooleanClause.Occur.MUST);
            for (Reference nullableRef : ctx.nullableReferences()) {
                Query refExistsQuery = IsNullPredicate.refExistsQuery(nullableRef, context);
                if (refExistsQuery != null) {
                    builder.add(refExistsQuery, BooleanClause.Occur.MUST);
                    continue;
                }
                return new BooleanQuery.Builder().add(notX, BooleanClause.Occur.MUST).add(LuceneQueryBuilder.genericFunctionFilter(input, context), BooleanClause.Occur.FILTER).build();
            }
            return builder.build();
        }
        return notX;
    }

    private static boolean countEmptyArrays(Symbol query, Reference reference, LuceneQueryBuilder.Context context) {
        Boolean b;
        if (!DataTypes.isArray(reference.valueType())) {
            return false;
        }
        Symbol querySymbolReplacedRefs = RefReplacer.replaceRefs(query, r -> r.equals(reference) ? Literal.of(new ArrayType(r.valueType()), List.of()) : r);
        Object evaluated = SymbolEvaluator.evaluateWithoutParams(context.transactionContext(), context.nodeContext(), querySymbolReplacedRefs);
        return !(evaluated instanceof Boolean) || (b = (Boolean)evaluated) != false;
    }

    private static class NullabilityVisitor
    extends SymbolVisitor<NullabilityContext, Void> {
        private final Set<String> CAST_FUNCTIONS = Set.of("_cast", "cast");

        private NullabilityVisitor() {
        }

        @Override
        public Void visitReference(Reference symbol, NullabilityContext context) {
            if (symbol.isNullable() && context.isNullable) {
                context.collectNullableReferences(symbol);
            }
            return null;
        }

        @Override
        public Void visitLiteral(Literal<?> symbol, NullabilityContext context) {
            if (symbol.symbolType().isValueSymbol() && symbol.value() == null && context.isNullable) {
                context.enforceThreeValuedLogic = true;
            }
            return null;
        }

        @Override
        public Void visitFunction(Function function, NullabilityContext context) {
            String functionName = function.name();
            if (this.CAST_FUNCTIONS.contains(functionName)) {
                Symbol a = function.arguments().get(0);
                Symbol b = function.arguments().get(1);
                if (a instanceof Reference) {
                    Reference ref = (Reference)a;
                    if (b instanceof Literal && ref.valueType().id() == DataTypes.UNTYPED_OBJECT.id()) {
                        context.enforceThreeValuedLogic = true;
                        return null;
                    }
                }
            } else {
                if ("ignore3vl".equals(functionName)) {
                    context.isNullable = false;
                    return null;
                }
                Signature signature = function.signature();
                if (signature.hasFeature(Scalar.Feature.NOTNULL)) {
                    context.isNullable = false;
                } else if (!signature.hasFeature(Scalar.Feature.STRICTNULL)) {
                    context.enforceThreeValuedLogic = true;
                    return null;
                }
            }
            boolean isNullable = context.isNullable;
            for (Symbol arg : function.arguments()) {
                arg.accept(this, context);
                context.isNullable = isNullable;
            }
            return null;
        }
    }

    private static class NullabilityContext {
        private final HashSet<Reference> nullableReferences = new HashSet();
        private boolean isNullable = true;
        private boolean enforceThreeValuedLogic = false;

        private NullabilityContext() {
        }

        void collectNullableReferences(Reference symbol) {
            this.nullableReferences.add(symbol);
        }

        Set<Reference> nullableReferences() {
            return this.nullableReferences;
        }

        boolean enforceThreeValuedLogic() {
            return this.enforceThreeValuedLogic;
        }
    }
}

