/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.exceptions.ArrayViaDocValuesUnsupportedException;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;

public abstract class BinaryColumnReference<T>
extends LuceneCollectorExpression<T> {
    private final String columnName;
    private SortedSetDocValues values;
    private int docId;

    public BinaryColumnReference(String columnName) {
        this.columnName = columnName;
    }

    protected abstract T convert(BytesRef var1);

    public final T value() throws ArrayViaDocValuesUnsupportedException {
        try {
            if (!this.values.advanceExact(this.docId)) {
                return null;
            }
            if (this.values.docValueCount() > 1) {
                throw new ArrayViaDocValuesUnsupportedException(this.columnName);
            }
            return this.convert(this.values.lookupOrd(this.values.nextOrd()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public final void setNextDocId(int docId) {
        this.docId = docId;
    }

    @Override
    public final void setNextReader(ReaderContext context) throws IOException {
        this.values = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.columnName);
    }
}

