/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.NumericDocValues;

public class VersionCollectorExpression
extends LuceneCollectorExpression<Long> {
    private NumericDocValues versions = null;
    private int docId;

    @Override
    public void setNextReader(ReaderContext context) throws IOException {
        try {
            this.versions = context.reader().getNumericDocValues(SysColumns.VERSION.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setNextDocId(int doc) {
        this.docId = doc;
    }

    public Long value() {
        try {
            if (this.versions != null && this.versions.advanceExact(this.docId)) {
                return this.versions.longValue();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }
}

