/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check;

import io.crate.expression.reference.sys.check.SysCheck;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractSysCheck
implements SysCheck {
    public static final String CLUSTER_CHECK_LINK_PATTERN = "https://cr8.is/d-cluster-check-";
    private final int id;
    private final String description;
    private final SysCheck.Severity severity;

    public AbstractSysCheck(int id, String description, SysCheck.Severity severity) {
        this(id, description, severity, CLUSTER_CHECK_LINK_PATTERN);
    }

    protected AbstractSysCheck(int id, String description, SysCheck.Severity severity, String linkPattern) {
        this.description = AbstractSysCheck.getLinkedDescription(id, description, linkPattern);
        this.id = id;
        this.severity = severity;
    }

    public static String getLinkedDescription(int id, String description, String linkPattern) {
        return description + " " + linkPattern + id;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public SysCheck.Severity severity() {
        return this.severity;
    }

    @Override
    public abstract boolean isValid();

    @Override
    public CompletableFuture<?> computeResult() {
        return CompletableFuture.completedFuture(null);
    }
}

