/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check;

import io.crate.expression.reference.sys.check.SysCheck;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class SysChecker<T extends SysCheck> {
    private final Set<T> sysChecks;

    public SysChecker(Set<T> sysChecks) {
        assert (this.idsAreUnique(sysChecks)) : "IDs of SysChecks are not unique";
        this.sysChecks = sysChecks;
    }

    public CompletableFuture<Iterable<T>> computeResultAndGet() {
        ArrayList futures = new ArrayList(this.sysChecks.size());
        for (SysCheck sysCheck : this.sysChecks) {
            futures.add(sysCheck.computeResult());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(aVoid -> this.sysChecks);
    }

    private boolean idsAreUnique(Set<T> sysChecks) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (SysCheck sysCheck : sysChecks) {
            if (ids.add(sysCheck.id())) continue;
            return false;
        }
        return true;
    }
}

