/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.DiskWatermarkNodesSysCheck;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeService;

@Singleton
public class FloodStageDiskWatermarkNodesSysCheck
extends DiskWatermarkNodesSysCheck {
    static final int ID = 7;
    private static final String DESCRIPTION = "The flood stage disk watermark is exceeded on the node. Tables that reside on an affected disk on this node have been made read-only. Please check the node disk usage.";

    @Inject
    public FloodStageDiskWatermarkNodesSysCheck(ClusterService clusterService, Settings settings, NodeService nodeService) {
        super(7, DESCRIPTION, SysCheck.Severity.HIGH, clusterService, nodeService.getMonitorService().fsService(), settings);
    }

    @Override
    protected boolean isValid(long free, long total) {
        return free >= this.diskThresholdSettings.getFreeBytesThresholdFloodStage().getBytes() && !(FloodStageDiskWatermarkNodesSysCheck.getFreeDiskAsPercentage(free, total) < this.diskThresholdSettings.getFreeDiskThresholdFloodStage());
    }
}

