/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.common.unit.TimeValue;
import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;

@Singleton
public class RecoveryAfterTimeSysCheck
extends AbstractSysNodeCheck {
    private final Settings settings;
    static final int ID = 3;
    private static final String DESCRIPTION = "If any of the \"expected data nodes\" recovery settings are set (or the deprecated \"expected nodes\" settings),the value of 'gateway.recover_after_time' must not be zero. Otherwise the \"expected (data) nodes\" setting wouldn't have any effect.";

    @Inject
    public RecoveryAfterTimeSysCheck(Settings settings) {
        super(3, DESCRIPTION, SysCheck.Severity.MEDIUM);
        this.settings = settings;
    }

    @Override
    public boolean isValid() {
        int afterNodes = GatewayService.RECOVER_AFTER_DATA_NODES_SETTING.get(this.settings);
        int expectedNodes = GatewayService.EXPECTED_DATA_NODES_SETTING.get(this.settings);
        int expectedNodesDefaultValue = GatewayService.EXPECTED_DATA_NODES_SETTING.getDefault(Settings.EMPTY);
        if (afterNodes == -1 || expectedNodes == expectedNodesDefaultValue) {
            afterNodes = GatewayService.RECOVER_AFTER_NODES_SETTING.get(this.settings);
            expectedNodes = GatewayService.EXPECTED_NODES_SETTING.get(this.settings);
            expectedNodesDefaultValue = GatewayService.EXPECTED_NODES_SETTING.getDefault(Settings.EMPTY);
        }
        return RecoveryAfterTimeSysCheck.validate(GatewayService.RECOVER_AFTER_TIME_SETTING.get(this.settings), afterNodes, expectedNodes, expectedNodesDefaultValue);
    }

    private static boolean validate(TimeValue recoverAfterTime, int recoveryAfterNodes, int expectedNodes, int expectedNodesDefaultValue) {
        return recoveryAfterNodes <= expectedNodes && (expectedNodes == expectedNodesDefaultValue || recoverAfterTime.millis() > 0L);
    }
}

