/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.node;

import io.crate.common.collections.Lists;
import io.crate.monitor.ExtendedOsStats;
import io.crate.protocols.ConnectionStats;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.util.Constants;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class NodeStatsContext
implements Writeable {
    private final boolean complete;
    private String id;
    private String name;
    private String hostname;
    private long timestamp;
    private Version version;
    private long clusterStateVersion;
    private Build build;
    private String restUrl;
    private Map<String, Object> attributes;
    private JvmStats jvmStats;
    private OsInfo osInfo;
    private ProcessStats processStats;
    private OsStats osStats;
    private ExtendedOsStats extendedOsStats;
    private FsInfo fsInfo;
    private ThreadPoolStats threadPools;
    private ConnectionStats httpStats;
    private ConnectionStats psqlStats;
    private String osName;
    private String osArch;
    private String osVersion;
    private String javaVersion;
    private String jvmName;
    private String jvmVendor;
    private String jvmVersion;
    private ConnectionStats transportStats;
    private Integer transportPort;
    private Integer httpPort;
    private Integer pgPort;

    public NodeStatsContext(String id, String name) {
        this(false);
        this.id = id;
        this.name = name;
    }

    public NodeStatsContext(boolean complete) {
        this.complete = complete;
        if (complete) {
            this.osName = Constants.OS_NAME;
            this.osArch = Constants.OS_ARCH;
            this.osVersion = Constants.OS_VERSION;
            this.jvmName = Constants.JVM_NAME;
            this.jvmVendor = Constants.JVM_VENDOR;
            Runtime.Version runtimeVersion = Runtime.version();
            this.javaVersion = Lists.joinOn((String)".", runtimeVersion.version(), num -> Integer.toString(num));
            this.jvmVersion = runtimeVersion.toString();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String hostname() {
        return this.hostname;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Version version() {
        return this.version;
    }

    public long clusterStateVersion() {
        return this.clusterStateVersion;
    }

    public Build build() {
        return this.build;
    }

    public String restUrl() {
        return this.restUrl;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public JvmStats jvmStats() {
        return this.jvmStats;
    }

    public OsInfo osInfo() {
        return this.osInfo;
    }

    public ProcessStats processStats() {
        return this.processStats;
    }

    public OsStats osStats() {
        return this.osStats;
    }

    public FsInfo fsInfo() {
        return this.fsInfo;
    }

    public ExtendedOsStats extendedOsStats() {
        return this.extendedOsStats;
    }

    public ThreadPoolStats threadPools() {
        return this.threadPools;
    }

    public String osName() {
        return this.osName;
    }

    public String osArch() {
        return this.osArch;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public String jvmName() {
        return this.jvmName;
    }

    public String jvmVendor() {
        return this.jvmVendor;
    }

    public String jvmVersion() {
        return this.jvmVersion;
    }

    public ConnectionStats httpStats() {
        return this.httpStats;
    }

    public ConnectionStats psqlStats() {
        return this.psqlStats;
    }

    public ConnectionStats transportStats() {
        return this.transportStats;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public Integer pgPort() {
        return this.pgPort;
    }

    public Integer transportPort() {
        return this.transportPort;
    }

    public void id(String id) {
        this.id = id;
    }

    public void name(String name) {
        this.name = name;
    }

    public void hostname(String hostname) {
        this.hostname = hostname;
    }

    public void timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void version(Version version) {
        this.version = version;
    }

    public void clusterStateVersion(long clusterStateVersion) {
        this.clusterStateVersion = clusterStateVersion;
    }

    public void build(Build build) {
        this.build = build;
    }

    public void restUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public void attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void httpPort(Integer http) {
        this.httpPort = http;
    }

    public void pgPort(Integer pgPort) {
        this.pgPort = pgPort;
    }

    public void transportPort(Integer transportPort) {
        this.transportPort = transportPort;
    }

    public void jvmStats(JvmStats jvmStats) {
        this.jvmStats = jvmStats;
    }

    public void osInfo(OsInfo osInfo) {
        this.osInfo = osInfo;
    }

    public void processStats(ProcessStats processStats) {
        this.processStats = processStats;
    }

    public void osStats(OsStats osStats) {
        this.osStats = osStats;
    }

    public void fsInfo(FsInfo fsInfo) {
        this.fsInfo = fsInfo;
    }

    public void extendedOsStats(ExtendedOsStats extendedOsStats) {
        this.extendedOsStats = extendedOsStats;
    }

    public void threadPools(ThreadPoolStats threadPools) {
        this.threadPools = threadPools;
    }

    public void httpStats(ConnectionStats httpStats) {
        this.httpStats = httpStats;
    }

    public void psqlStats(ConnectionStats psqlStats) {
        this.psqlStats = psqlStats;
    }

    void transportStats(ConnectionStats transportStats) {
        this.transportStats = transportStats;
    }

    public NodeStatsContext(StreamInput in, boolean complete) throws IOException {
        this.complete = complete;
        this.id = DataTypes.STRING.readValueFrom(in);
        this.name = DataTypes.STRING.readValueFrom(in);
        this.hostname = DataTypes.STRING.readValueFrom(in);
        this.timestamp = in.readLong();
        this.version = in.readBoolean() ? Version.readVersion(in) : null;
        this.build = in.readBoolean() ? Build.readBuild(in) : null;
        this.restUrl = DataTypes.STRING.readValueFrom(in);
        if (in.getVersion().onOrAfter(Version.V_5_2_0)) {
            this.attributes = in.readMap();
        }
        this.pgPort = in.readOptionalVInt();
        this.httpPort = in.readOptionalVInt();
        this.transportPort = in.readOptionalVInt();
        this.jvmStats = in.readOptionalWriteable(JvmStats::new);
        this.osInfo = in.readOptionalWriteable(OsInfo::new);
        this.processStats = in.readOptionalWriteable(ProcessStats::new);
        this.osStats = in.readOptionalWriteable(OsStats::new);
        this.fsInfo = in.readOptionalWriteable(FsInfo::new);
        this.extendedOsStats = in.readOptionalWriteable(ExtendedOsStats::new);
        this.threadPools = in.readOptionalWriteable(ThreadPoolStats::new);
        if (in.getVersion().onOrAfter(Version.V_5_8_0)) {
            this.httpStats = in.readOptionalWriteable(ConnectionStats::new);
            this.psqlStats = in.readOptionalWriteable(ConnectionStats::new);
            this.transportStats = in.readOptionalWriteable(ConnectionStats::new);
        } else {
            this.httpStats = in.readBoolean() ? new ConnectionStats(in.readVLong(), in.readVLong(), -1L, -1L, -1L, -1L) : new ConnectionStats(-1L, -1L, -1L, -1L, -1L, -1L);
            this.psqlStats = in.readBoolean() ? new ConnectionStats(in.readVLong(), in.readVLong(), -1L, -1L, -1L, -1L) : new ConnectionStats(-1L, -1L, -1L, -1L, -1L, -1L);
            this.transportStats = new ConnectionStats(in.readLong(), -1L, -1L, -1L, -1L, -1L);
        }
        this.clusterStateVersion = in.readLong();
        this.osName = DataTypes.STRING.readValueFrom(in);
        this.osArch = DataTypes.STRING.readValueFrom(in);
        this.osVersion = DataTypes.STRING.readValueFrom(in);
        this.javaVersion = DataTypes.STRING.readValueFrom(in);
        this.jvmName = DataTypes.STRING.readValueFrom(in);
        this.jvmVendor = DataTypes.STRING.readValueFrom(in);
        this.jvmVersion = DataTypes.STRING.readValueFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataTypes.STRING.writeValueTo(out, this.id);
        DataTypes.STRING.writeValueTo(out, this.name);
        DataTypes.STRING.writeValueTo(out, this.hostname);
        out.writeLong(this.timestamp);
        out.writeBoolean(this.version != null);
        if (this.version != null) {
            Version.writeVersion(this.version, out);
        }
        out.writeBoolean(this.build != null);
        if (this.build != null) {
            Build.writeBuildTo(this.build, out);
        }
        DataTypes.STRING.writeValueTo(out, this.restUrl);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeMap(this.attributes);
        }
        out.writeOptionalVInt(this.pgPort);
        out.writeOptionalVInt(this.httpPort);
        out.writeOptionalVInt(this.transportPort);
        out.writeOptionalWriteable(this.jvmStats);
        out.writeOptionalWriteable(this.osInfo);
        out.writeOptionalWriteable(this.processStats);
        out.writeOptionalWriteable(this.osStats);
        out.writeOptionalWriteable(this.fsInfo);
        out.writeOptionalWriteable(this.extendedOsStats);
        out.writeOptionalWriteable(this.threadPools);
        if (out.getVersion().onOrAfter(Version.V_5_8_0)) {
            out.writeOptionalWriteable(this.httpStats);
            out.writeOptionalWriteable(this.psqlStats);
            out.writeOptionalWriteable(this.transportStats);
        } else {
            if (this.httpStats != null) {
                out.writeBoolean(true);
                out.writeVLong(this.httpStats.open());
                out.writeVLong(this.httpStats.total());
            } else {
                out.writeBoolean(false);
            }
            if (this.psqlStats != null) {
                out.writeBoolean(true);
                out.writeVLong(this.psqlStats.open());
                out.writeVLong(this.psqlStats.total());
            } else {
                out.writeBoolean(false);
            }
            if (this.transportStats != null) {
                out.writeLong(this.transportStats.open());
            } else {
                out.writeLong(-1L);
            }
        }
        out.writeLong(this.clusterStateVersion);
        DataTypes.STRING.writeValueTo(out, this.osName);
        DataTypes.STRING.writeValueTo(out, this.osArch);
        DataTypes.STRING.writeValueTo(out, this.osVersion);
        DataTypes.STRING.writeValueTo(out, this.javaVersion);
        DataTypes.STRING.writeValueTo(out, this.jvmName);
        DataTypes.STRING.writeValueTo(out, this.jvmVendor);
        DataTypes.STRING.writeValueTo(out, this.jvmVersion);
    }
}

