/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.shard;

import io.crate.expression.reference.sys.shard.SysAllocation;
import io.crate.metadata.IndexName;
import java.util.Iterator;
import java.util.function.Supplier;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.snapshots.SnapshotsInfoService;

@Singleton
public class SysAllocations
implements Iterable<SysAllocation> {
    private final ClusterService clusterService;
    private final ClusterInfoService clusterInfoService;
    private final AllocationDeciders allocationDeciders;
    private final AllocationService allocationService;
    private final SnapshotsInfoService snapshotInfoService;

    @Inject
    public SysAllocations(ClusterService clusterService, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotInfoService, AllocationDeciders allocationDeciders, AllocationService allocationService) {
        this.clusterService = clusterService;
        this.clusterInfoService = clusterInfoService;
        this.snapshotInfoService = snapshotInfoService;
        this.allocationDeciders = allocationDeciders;
        this.allocationService = allocationService;
    }

    @Override
    public Iterator<SysAllocation> iterator() {
        ClusterState state = this.clusterService.state();
        RoutingNodes routingNodes = state.getRoutingNodes();
        ClusterInfo clusterInfo = this.clusterInfoService.getClusterInfo();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, state, clusterInfo, this.snapshotInfoService.snapshotShardSizes(), System.nanoTime());
        return allocation.routingTable().allShards().stream().filter(shardRouting -> !IndexName.isDangling(shardRouting.getIndexName())).map(shardRouting -> this.createSysAllocations(allocation, (ShardRouting)shardRouting)).iterator();
    }

    private SysAllocation createSysAllocations(RoutingAllocation allocation, ShardRouting shardRouting) {
        allocation.setDebugMode(RoutingAllocation.DebugMode.EXCLUDE_YES_DECISIONS);
        Supplier<ShardAllocationDecision> shardDecision = () -> {
            if (shardRouting.initializing() || shardRouting.relocating()) {
                return ShardAllocationDecision.NOT_TAKEN;
            }
            return this.allocationService.explainShardAllocation(shardRouting, allocation);
        };
        return new SysAllocation(shardRouting.shardId(), shardRouting.state(), shardDecision, shardRouting.currentNodeId(), shardRouting.primary());
    }
}

