/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.array.ArrayArgumentValidators;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.role.Roles;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class ArrayDifferenceFunction
extends Scalar<List<Object>, List<Object>> {
    public static final String NAME = "array_difference";
    private final Optional<Set<Object>> optionalSubtractSet;

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("array(E)"), TypeSignature.parse("array(E)")).returnType(TypeSignature.parse("array(E)")).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), (signature, boundSignature) -> new ArrayDifferenceFunction((Signature)signature, (BoundSignature)boundSignature, null));
    }

    private ArrayDifferenceFunction(Signature signature, BoundSignature boundSignature, @Nullable Set<Object> subtractSet) {
        super(signature, boundSignature);
        this.optionalSubtractSet = Optional.ofNullable(subtractSet);
        ArrayArgumentValidators.ensureBothInnerTypesAreNotUndefined(boundSignature.argTypes(), NAME);
    }

    @Override
    public Scalar<List<Object>, List<Object>> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        Set<Object> subtractSet;
        Symbol symbol = arguments.get(1);
        if (!symbol.symbolType().isValueSymbol()) {
            return this;
        }
        Input input = (Input)symbol;
        Object inputValue = input.value();
        DataType innerType = ((ArrayType)this.boundSignature.returnType()).innerType();
        List values = (List)inputValue;
        if (values == null) {
            subtractSet = Collections.emptySet();
        } else {
            subtractSet = new HashSet();
            for (Object element : values) {
                subtractSet.add(innerType.sanitizeValue(element));
            }
        }
        return new ArrayDifferenceFunction(this.signature, this.boundSignature, subtractSet);
    }

    @Override
    public List<Object> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        Set<Object> localSubtractSet;
        List inputValues = (List)args[0].value();
        if (inputValues == null) {
            return null;
        }
        DataType innerType = ((ArrayType)this.boundSignature.returnType()).innerType();
        if (this.optionalSubtractSet.isEmpty()) {
            localSubtractSet = new HashSet();
            for (int i = 1; i < args.length; ++i) {
                Object argValue = args[i].value();
                if (argValue == null) continue;
                List values = (List)argValue;
                for (Object element : values) {
                    localSubtractSet.add(innerType.sanitizeValue(element));
                }
            }
        } else {
            localSubtractSet = this.optionalSubtractSet.get();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(inputValues.size());
        for (Object value : inputValues) {
            if (localSubtractSet.contains(innerType.sanitizeValue(value))) continue;
            resultList.add(value);
        }
        return resultList;
    }
}

