/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.role.Roles;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class SubstrFunction
extends Scalar<String, Object> {
    public static final String NAME = "substr";
    public static final String ALIAS = "substring";

    public static void register(Functions.Builder builder) {
        TypeSignature stringType = DataTypes.STRING.getTypeSignature();
        TypeSignature intType = DataTypes.INTEGER.getTypeSignature();
        for (String name : List.of(NAME, ALIAS)) {
            builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(stringType, intType).returnType(stringType).features(Scalar.Feature.DETERMINISTIC).build(), SubstrFunction::new);
            builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(stringType, intType, intType).returnType(stringType).features(Scalar.Feature.DETERMINISTIC).build(), SubstrFunction::new);
            builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(stringType, stringType).returnType(stringType).features(Scalar.Feature.DETERMINISTIC).build(), SubstrExtractFunction::new);
        }
    }

    private SubstrFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 2 || args.length == 3) : "number of arguments must be 2 or 3";
        String val = (String)args[0].value();
        if (val == null) {
            return null;
        }
        Number beginIdx = (Number)args[1].value();
        if (beginIdx == null) {
            return null;
        }
        if (args.length == 3) {
            Number len = (Number)args[2].value();
            if (len == null) {
                return null;
            }
            return SubstrFunction.evaluate(val, beginIdx.intValue(), len.intValue());
        }
        return SubstrFunction.evaluate(val, beginIdx.intValue());
    }

    private static String evaluate(@NotNull String inputStr, int beginIdx) {
        int startPos = Math.max(0, beginIdx - 1);
        if (startPos > inputStr.length() - 1) {
            return "";
        }
        int endPos = inputStr.length();
        return SubstrFunction.substring(inputStr, startPos, endPos);
    }

    @VisibleForTesting
    static String evaluate(@NotNull String inputStr, int beginIdx, int len) {
        int startPos = Math.max(0, beginIdx - 1);
        if (startPos > inputStr.length() - 1) {
            return "";
        }
        int endPos = inputStr.length();
        if (startPos + len < endPos) {
            endPos = startPos + len;
        }
        return SubstrFunction.substring(inputStr, startPos, endPos);
    }

    @VisibleForTesting
    static String substring(String value, int begin, int end) {
        return value.substring(begin, end);
    }

    private static class CompiledSubstr
    extends Scalar<String, String> {
        private final Matcher matcher;

        public CompiledSubstr(Signature signature, BoundSignature boundSignature, String pattern) {
            super(signature, boundSignature);
            this.matcher = Pattern.compile(pattern).matcher("");
        }

        @Override
        @SafeVarargs
        public final String evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<String> ... args) {
            String string = (String)args[0].value();
            if (string == null) {
                return null;
            }
            this.matcher.reset(string);
            int groupCount = this.matcher.groupCount();
            if (this.matcher.find()) {
                String group = this.matcher.group(groupCount > 0 ? 1 : 0);
                return group;
            }
            return null;
        }
    }

    private static class SubstrExtractFunction
    extends Scalar<String, String> {
        SubstrExtractFunction(Signature signature, BoundSignature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        @SafeVarargs
        public final String evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<String> ... args) {
            String string = (String)args[0].value();
            if (string == null) {
                return null;
            }
            String pattern = (String)args[1].value();
            if (pattern == null) {
                return null;
            }
            Pattern re = Pattern.compile(pattern);
            Matcher matcher = re.matcher(string);
            int groupCount = matcher.groupCount();
            if (matcher.find()) {
                String group = matcher.group(groupCount > 0 ? 1 : 0);
                return group;
            }
            return null;
        }

        @Override
        public Scalar<String, String> compile(List<Symbol> arguments, String currentUser, Roles roles) {
            Symbol patternSymbol = arguments.get(1);
            if (patternSymbol instanceof Input) {
                Input input = (Input)patternSymbol;
                String pattern = (String)input.value();
                if (pattern == null) {
                    return this;
                }
                return new CompiledSubstr(this.signature, this.boundSignature, pattern);
            }
            return this;
        }
    }
}

