/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import ch.obermuhlner.math.big.BigDecimalMath;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.DoubleType;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;
import java.math.MathContext;

public class ExpFunction {
    public static final String NAME = "exp";

    private ExpFunction() {
    }

    public static void register(Functions.Builder builder) {
        DoubleType type = DataTypes.DOUBLE;
        TypeSignature signature = type.getTypeSignature();
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(signature).returnType(signature).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (declaredSignature, boundSignature) -> new UnaryScalar<Double, Double>((Signature)declaredSignature, (BoundSignature)boundSignature, type, x -> type.sanitizeValue(Math.exp(x))));
        builder.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (declaredSignature, ignoredBoundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)declaredSignature, BoundSignature.sameAsUnbound(declaredSignature), DataTypes.NUMERIC, x -> BigDecimalMath.exp((BigDecimal)x, (MathContext)MathContext.DECIMAL128)));
    }
}

