/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.array;

import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Locale;

public class ArrayArgumentValidators {
    public static void ensureInnerTypeIsNotUndefined(List<DataType<?>> dataTypes, String functionName) {
        DataType innerType = ((ArrayType)dataTypes.get(0)).innerType();
        if (innerType.equals(DataTypes.UNDEFINED)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The inner type of the array argument `%s` function cannot be undefined", functionName));
        }
    }

    public static void ensureBothInnerTypesAreNotUndefined(List<DataType<?>> dataTypes, String functionName) {
        DataType innerType0 = ((ArrayType)dataTypes.get(0)).innerType();
        DataType innerType1 = ((ArrayType)dataTypes.get(1)).innerType();
        if (innerType0.equals(DataTypes.UNDEFINED) || innerType1.equals(DataTypes.UNDEFINED)) {
            throw new IllegalArgumentException("One of the arguments of the `" + functionName + "` function can be of undefined inner type, but not both");
        }
    }

    public static void ensureSingleArgumentArrayInnerTypeIsNotUndefined(List<DataType<?>> dataTypes) {
        DataType innerType = ((ArrayType)dataTypes.get(0)).innerType();
        if (innerType.equals(DataTypes.UNDEFINED)) {
            throw new IllegalArgumentException("When used with only one argument, the inner type of the array argument cannot be undefined");
        }
    }
}

