/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import org.locationtech.spatial4j.shape.Point;

public final class CoordinateFunction {
    public static void register(Functions.Builder module) {
        module.add(Signature.builder("latitude", FunctionType.SCALAR).argumentTypes(DataTypes.GEO_POINT.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Double, Point>((Signature)signature, (BoundSignature)boundSignature, DataTypes.GEO_POINT, CoordinateFunction::getLatitude));
        module.add(Signature.builder("longitude", FunctionType.SCALAR).argumentTypes(DataTypes.GEO_POINT.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar<Double, Point>((Signature)signature, (BoundSignature)boundSignature, DataTypes.GEO_POINT, CoordinateFunction::getLongitude));
    }

    private static Double getLatitude(Object value) {
        return DataTypes.GEO_POINT.sanitizeValue(value).getY();
    }

    private static Double getLongitude(Object value) {
        return DataTypes.GEO_POINT.sanitizeValue(value).getX();
    }
}

