/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.exceptions.RelationUnknown;
import io.crate.expression.scalar.HasTablePrivilegeFunction;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Scalar;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.settings.SessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.role.Permission;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.sql.tree.QualifiedName;
import io.crate.types.DataTypes;

public class PgTableIsVisibleFunction
extends Scalar<Boolean, Integer> {
    private static final FunctionName NAME = new FunctionName("pg_catalog", "pg_table_is_visible");

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.INTEGER.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), PgTableIsVisibleFunction::new);
    }

    protected PgTableIsVisibleFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeContext, Input<Integer> ... args) {
        assert (args.length == 1) : String.valueOf(NAME) + " expects exactly 1 argument, got " + args.length;
        Integer tableOid = (Integer)args[0].value();
        if (tableOid == null) {
            return null;
        }
        Schemas schemas = nodeContext.schemas();
        RelationName relationName = schemas.getRelation(tableOid);
        if (relationName == null) {
            return false;
        }
        SessionSettings sessionSettings = txnCtx.sessionSettings();
        Roles roles = nodeContext.roles();
        Role user = roles.findUser(sessionSettings.userName());
        for (String searchPathIdx : sessionSettings.searchPath()) {
            try {
                schemas.findRelation(QualifiedName.of((String)searchPathIdx, (String[])new String[]{relationName.name()}), Operation.READ, user, SearchPath.createSearchPathFrom(searchPathIdx));
            }
            catch (RelationUnknown e) {
                continue;
            }
            boolean foundMatchingSchemaName = searchPathIdx.equals(relationName.schema());
            if (HasTablePrivilegeFunction.checkByTableName(roles, user, new RelationName(searchPathIdx, relationName.name()).fqn(), Permission.READ_WRITE_DEFINE, schemas)) {
                return foundMatchingSchemaName;
            }
            if (!foundMatchingSchemaName) continue;
            break;
        }
        return false;
    }
}

