/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public final class LengthFunction {
    public static void register(Functions.Builder builder) {
        LengthFunction.register(builder, "octet_length", x -> x.getBytes(StandardCharsets.UTF_8).length);
        LengthFunction.register(builder, "bit_length", x -> x.getBytes(StandardCharsets.UTF_8).length * 8);
        LengthFunction.register(builder, "char_length", String::length);
        LengthFunction.register(builder, "length", String::length);
    }

    private static void register(Functions.Builder builder, String name, Function<String, Integer> func) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new UnaryScalar((Signature)signature, (BoundSignature)boundSignature, DataTypes.STRING, func));
    }
}

