/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;

public final class ParseURIFunction
extends Scalar<Object, String> {
    private static final String NAME = "parse_uri";

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(NAME, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature()).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), ParseURIFunction::new);
    }

    public ParseURIFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String> ... args) {
        String uri = (String)args[0].value();
        if (uri == null) {
            return null;
        }
        return this.parseURI(uri);
    }

    private final Object parseURI(String uriText) {
        HashMap<String, Object> uriMap = new HashMap<String, Object>();
        URI uri = null;
        try {
            uri = new URI(uriText);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "unable to parse uri %s", uriText));
        }
        uriMap.put("scheme", uri.getScheme());
        uriMap.put("userinfo", uri.getUserInfo());
        uriMap.put("hostname", uri.getHost());
        uriMap.put("port", uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort()));
        uriMap.put("path", uri.getPath());
        uriMap.put("query", uri.getQuery());
        uriMap.put("fragment", uri.getFragment());
        return uriMap;
    }
}

