/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.EnumSet;
import java.util.Locale;
import org.elasticsearch.Build;
import org.elasticsearch.Version;

public class VersionFunction
extends Scalar<String, Void> {
    public static final String NAME = "version";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "version");
    private static final String VERSION = VersionFunction.formatVersion();

    public static void register(Functions.Builder module) {
        module.add(Signature.builder(FQN, FunctionType.SCALAR).argumentTypes(new TypeSignature[0]).returnType(DataTypes.STRING.getTypeSignature()).features(EnumSet.of(Scalar.Feature.NOTNULL)).build(), VersionFunction::new);
    }

    private static String formatVersion() {
        String version = Version.displayVersion(Version.CURRENT, Version.CURRENT.isSnapshot());
        String built = String.format(Locale.ENGLISH, "built %s/%s", Build.CURRENT.hashShort(), Build.CURRENT.timestamp());
        String vmVersion = String.format(Locale.ENGLISH, "%s %s", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"));
        String osVersion = String.format(Locale.ENGLISH, "%s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        return String.format(Locale.ENGLISH, "CrateDB %s (%s, %s, %s)", version, built, osVersion, vmVersion);
    }

    public VersionFunction(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    @SafeVarargs
    public final String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Void> ... args) {
        return VERSION;
    }
}

