/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Aggregation;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.DynamicReference;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.VoidReference;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.SimpleReference;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;

public enum SymbolType {
    AGGREGATION(Aggregation::new),
    REFERENCE(SimpleReference::new),
    RELATION_OUTPUT(in -> {
        throw new UnsupportedOperationException("Field is not streamable");
    }),
    FUNCTION(Function::new),
    WINDOW_FUNCTION(WindowFunction::new),
    LITERAL(Literal::new),
    INPUT_COLUMN(InputColumn::new),
    DYNAMIC_REFERENCE(DynamicReference::new),
    MATCH_PREDICATE(null),
    FETCH_REFERENCE(null),
    INDEX_REFERENCE(IndexReference::new),
    GEO_REFERENCE(GeoReference::new),
    GENERATED_REFERENCE(GeneratedReference::new),
    PARAMETER(ParameterSymbol::new),
    SELECT_SYMBOL(in -> {
        throw new UnsupportedOperationException("SelectSymbol is not streamable");
    }),
    ALIAS(AliasSymbol::new),
    FETCH_STUB(in -> {
        throw new UnsupportedEncodingException("FetchStub is not streamable");
    }),
    VOID_REFERENCE(VoidReference::new);

    public static final List<SymbolType> VALUES;
    private final Writeable.Reader<Symbol> reader;

    private SymbolType(Writeable.Reader<Symbol> reader) {
        this.reader = reader;
    }

    public Symbol newInstance(StreamInput in) throws IOException {
        return this.reader.read(in);
    }

    public boolean isValueSymbol() {
        return this.ordinal() == LITERAL.ordinal();
    }

    public boolean isValueOrParameterSymbol() {
        return this.ordinal() == LITERAL.ordinal() || this.ordinal() == PARAMETER.ordinal();
    }

    static {
        VALUES = List.of(SymbolType.values());
    }
}

