/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.tablefunctions;

import io.crate.common.collections.Iterators;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.tablefunctions.ColumnOrientedRowsIterator;
import io.crate.legacy.LegacySettings;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.settings.Settings;

public class UnnestFunction {
    public static final String NAME = "unnest";

    public static void register(Functions.Builder builder, Settings settings) {
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(TypeSignature.parse("array(N)")).returnType(RowType.EMPTY.getTypeSignature()).features(Scalar.Feature.NOTNULL, Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariableOfAnyType("N")).setVariableArity(true).build(), (signature, boundSignature) -> {
            List fieldTypes = Lists.map(boundSignature.argTypes(), ArrayType::unnest);
            Boolean useLegacyName = LegacySettings.LEGACY_TABLE_FUNCTION_COLUMN_NAMING.get(settings);
            List<String> fieldNames = fieldTypes.size() == 1 && useLegacyName == false ? List.of(NAME) : List.of();
            RowType returnType = new RowType(fieldTypes, fieldNames);
            BoundSignature newBoundSignature = new BoundSignature(boundSignature.argTypes(), fieldTypes.size() == 1 ? (DataType)fieldTypes.get(0) : returnType);
            return new UnnestTableFunctionImplementation((Signature)signature, newBoundSignature, returnType);
        });
        builder.add(Signature.builder(NAME, FunctionType.TABLE).argumentTypes(new TypeSignature[0]).returnType(DataTypes.UNTYPED_OBJECT.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).build(), (signature, boundSignature) -> new UnnestTableFunctionImplementation((Signature)signature, (BoundSignature)boundSignature, RowType.EMPTY));
    }

    static class UnnestTableFunctionImplementation
    extends TableFunctionImplementation<List<Object>> {
        private final RowType returnType;
        private final List<DataType<?>> argumentTypes;

        private UnnestTableFunctionImplementation(Signature signature, BoundSignature boundSignature, RowType returnType) {
            super(signature, boundSignature);
            this.argumentTypes = boundSignature.argTypes();
            this.returnType = returnType;
        }

        @Override
        public RowType returnType() {
            return this.returnType;
        }

        @Override
        public boolean hasLazyResultSet() {
            return false;
        }

        @Override
        @SafeVarargs
        public final Iterable<Row> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<List<Object>> ... arguments) {
            ArrayList<List> valuesPerColumn = new ArrayList<List>(arguments.length);
            for (Input<List<Object>> argument : arguments) {
                valuesPerColumn.add((List)argument.value());
            }
            return new ColumnOrientedRowsIterator(() -> this.createIterators(valuesPerColumn));
        }

        private Iterator<Object>[] createIterators(ArrayList<List<Object>> valuesPerColumn) {
            Iterator[] iterators = new Iterator[valuesPerColumn.size()];
            for (int i = 0; i < valuesPerColumn.size(); ++i) {
                DataType<?> dataType = this.argumentTypes.get(i);
                assert (dataType instanceof ArrayType) : "Argument to unnest must be an array";
                iterators[i] = UnnestTableFunctionImplementation.createIterator(valuesPerColumn.get(i), (ArrayType)dataType);
            }
            return iterators;
        }

        private static Iterator<Object> createIterator(List<Object> objects, ArrayType<?> type) {
            if (objects == null) {
                return Collections.emptyIterator();
            }
            if (type.innerType() instanceof ArrayType) {
                List iterators = Lists.map(objects, x -> UnnestTableFunctionImplementation.createIterator((List)x, (ArrayType)type.innerType()));
                return Iterators.concat((Iterator[])iterators.toArray(new Iterator[0]));
            }
            return objects.iterator();
        }
    }
}

