/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.CreateServerRequest;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ServerAlreadyExistsException;
import io.crate.fdw.ServersMetadata;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public final class AddServerTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final ForeignDataWrappers foreignDataWrappers;
    private final CreateServerRequest request;

    public AddServerTask(ForeignDataWrappers foreignDataWrappers, CreateServerRequest request) {
        super(Priority.NORMAL, request);
        this.foreignDataWrappers = foreignDataWrappers;
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        String serverName;
        if (!this.foreignDataWrappers.contains(this.request.fdw())) {
            throw new IllegalArgumentException("foreign-data wrapper " + this.request.fdw() + " does not exist");
        }
        ServersMetadata serversMetadata = currentState.metadata().custom("servers", ServersMetadata.EMPTY);
        if (serversMetadata.contains(serverName = this.request.name())) {
            if (this.request.ifNotExists()) {
                return currentState;
            }
            throw new ServerAlreadyExistsException(serverName);
        }
        ServersMetadata newServersMetadata = serversMetadata.add(serverName, this.request.fdw(), this.request.owner(), this.request.options());
        return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("servers", newServersMetadata)).build();
    }
}

