/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.DropServerRequest;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.fdw.ServersMetadata;
import io.crate.sql.tree.CascadeMode;
import java.util.Locale;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Priority;

public class DropServerTask
extends AckedClusterStateUpdateTask<AcknowledgedResponse> {
    private final DropServerRequest request;

    public DropServerTask(DropServerRequest request) {
        super(Priority.NORMAL, request);
        this.request = request;
    }

    @Override
    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return new AcknowledgedResponse(acknowledged);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        ServersMetadata updatedServers;
        ForeignTablesMetadata foreignTables;
        Metadata metadata = currentState.metadata();
        ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
        ForeignTablesMetadata updatedForeignTables = foreignTables = metadata.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        if (this.request.mode() == CascadeMode.RESTRICT) {
            for (String serverName : this.request.names()) {
                if (!foreignTables.anyDependOnServer(serverName)) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot drop server `%s` because foreign tables depend on it", serverName));
            }
        } else {
            updatedForeignTables = foreignTables.removeAllForServers(this.request.names());
        }
        if ((updatedServers = servers.remove(this.request.names(), this.request.ifExists(), this.request.mode())) == servers && updatedForeignTables == foreignTables) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(Metadata.builder(metadata).putCustom("servers", updatedServers).putCustom("foreign_tables", updatedForeignTables)).build();
    }
}

