/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.ForeignTable;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.table.Operation;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ForeignTableRelation
extends AbstractTableRelation<ForeignTable> {
    public ForeignTableRelation(ForeignTable table) {
        super(table, List.copyOf(table.columns()), List.of());
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitForeignTable(this, context);
    }

    @Override
    @Nullable
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        if (operation != Operation.READ) {
            throw new UnsupportedOperationException("Cannot write or delete on foreign tables");
        }
        Reference reference = ((ForeignTable)this.tableInfo).getReadReference(column);
        if (reference == null) {
            throw new ColumnUnknownException(column, ((ForeignTable)this.tableInfo).name());
        }
        return reference;
    }
}

