/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.pipeline.InputRowProjector;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.settings.SessionSettings;
import io.crate.role.Role;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

final class JdbcForeignDataWrapper
implements ForeignDataWrapper {
    private static final Set<String> SAFE_FUNCTIONS = Set.of("op_and", "op_or", "op_not", "op_=", "op_>", "op_>=", "op_<", "op_<=");
    private final InputFactory inputFactory;
    private final Settings settings;
    private final Setting<String> urlSetting = Setting.simpleString("url", new Setting.Property[0]);
    private final List<Setting<?>> mandatoryServerOptions = List.of(this.urlSetting);
    private final Setting<String> schemaName = Setting.simpleString("schema_name", new Setting.Property[0]);
    private final Setting<String> tableName = Setting.simpleString("table_name", new Setting.Property[0]);
    private final List<Setting<?>> optionalTableOptions = List.of(this.schemaName, this.tableName);
    private final Setting<String> foreignUser = Setting.simpleString("user", new Setting.Property[0]);
    private final Setting<String> foreignPw = Setting.simpleString("password", new Setting.Property[0]);
    private final List<Setting<?>> optionalUserOptions = List.of(this.foreignUser, this.foreignPw);

    JdbcForeignDataWrapper(Settings settings, InputFactory inputFactory) {
        this.settings = settings;
        this.inputFactory = inputFactory;
    }

    @Override
    public List<Setting<?>> mandatoryServerOptions() {
        return this.mandatoryServerOptions;
    }

    @Override
    public List<Setting<?>> optionalTableOptions() {
        return this.optionalTableOptions;
    }

    @Override
    public List<Setting<?>> optionalUserOptions() {
        return this.optionalUserOptions;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(Role currentUser, ServersMetadata.Server server, ForeignTable foreignTable, TransactionContext txnCtx, List<Symbol> collect, Symbol query) {
        InetAddress inetAddress;
        URI uri;
        SessionSettings sessionSettings = txnCtx.sessionSettings();
        Settings userOptions = server.users().get(currentUser.name());
        if (userOptions == null) {
            userOptions = Settings.EMPTY;
        }
        String user = this.foreignUser.get(userOptions);
        String password = this.foreignPw.get(userOptions);
        Properties properties = new Properties();
        properties.setProperty("user", user.isEmpty() ? sessionSettings.userName() : user);
        if (!password.isEmpty()) {
            properties.setProperty("password", password);
        }
        ArrayList<Reference> refs = new ArrayList<Reference>(collect.size());
        for (Symbol symbol : collect) {
            symbol.visit(Reference.class, refs::add);
        }
        Settings options = server.options();
        String url = this.urlSetting.get(options);
        if (!url.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Invalid JDBC connection string provided");
        }
        try {
            uri = new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String host = uri.getHost();
        if (host == null) {
            throw new IllegalArgumentException("Invalid JDBC connection string provided");
        }
        try {
            inetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if ((inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) && !currentUser.isSuperUser() && !ForeignDataWrappers.ALLOW_LOCAL.get(this.settings).booleanValue()) {
            throw new UnsupportedOperationException("Only a super user can connect to localhost unless `fdw.allow_local` is set to true");
        }
        String remoteSchema = this.schemaName.get(foreignTable.options());
        String remoteTable = this.tableName.get(foreignTable.options());
        RelationName remoteName = new RelationName(remoteSchema.isEmpty() ? foreignTable.name().schema() : remoteSchema, remoteTable.isEmpty() ? foreignTable.name().name() : remoteTable);
        assert (this.supportsQueryPushdown(query)) : "ForeignCollect must only have a query where `supportsQueryPushDown` is true";
        BatchIterator<Row> it = new BatchIterator<Row>(url, properties, refs, query, remoteName);
        if (!refs.containsAll(collect)) {
            InputColumns.SourceSymbols sourceRefs = new InputColumns.SourceSymbols(refs);
            List<Symbol> inputColumns = InputColumns.create(collect, sourceRefs);
            InputFactory.Context<CollectExpression<Row, ?>> inputCtx = this.inputFactory.ctxForInputColumns(txnCtx, inputColumns);
            InputRowProjector inputRowProjector = new InputRowProjector(inputCtx.topLevelInputs(), inputCtx.expressions());
            it = inputRowProjector.apply(it);
        }
        return CompletableFuture.completedFuture(it);
    }

    @Override
    public boolean supportsQueryPushdown(Symbol query) {
        return !query.any(x -> {
            Function fn;
            return x instanceof Function && !SAFE_FUNCTIONS.contains((fn = (Function)x).name());
        });
    }
}

