/*
 * Decompiled with CFR 0.152.
 */
package io.crate.fdw;

import io.crate.fdw.AddServerTask;
import io.crate.fdw.CreateServerRequest;
import io.crate.fdw.ForeignDataWrappers;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportCreateServerAction
extends TransportMasterNodeAction<CreateServerRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final ForeignDataWrappers foreignDataWrappers;

    @Inject
    public TransportCreateServerAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ForeignDataWrappers foreignDataWrappers) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateServerRequest::new);
        this.foreignDataWrappers = foreignDataWrappers;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreateServerRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (state.nodes().getMinNodeVersion().before(Version.V_5_7_0)) {
            throw new IllegalStateException("Cannot execute CREATE SERVER while there are <5.7.0 nodes in the cluster");
        }
        AddServerTask updateTask = new AddServerTask(this.foreignDataWrappers, request);
        updateTask.completionFuture().whenComplete(listener);
        this.clusterService.submitStateUpdateTask("create_server", updateTask);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateServerRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        public static final String NAME = "internal:crate:sql/fdw/server/create";

        private Action() {
            super(NAME);
        }
    }
}

