/*
 * Decompiled with CFR 0.152.
 */
package io.crate.license;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class License
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String WRITEABLE_TYPE = "license";
    private String licenseKey;

    public License(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public License(StreamInput in) throws IOException {
        this.readFrom(in);
    }

    public void readFrom(StreamInput in) throws IOException {
        this.licenseKey = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.licenseKey);
    }

    public static License fromXContent(XContentParser parser) throws IOException {
        String licenseKey = null;
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME || !Objects.equals(parser.currentName(), WRITEABLE_TYPE)) {
            throw new IllegalArgumentException("license FIELD_NAME expected but got " + String.valueOf(parser.currentToken()));
        }
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("license START_OBJECT expected but got " + String.valueOf(parser.currentToken()));
        }
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            if ("license_key".equals(parser.currentName())) {
                licenseKey = License.parseStringField(parser);
                continue;
            }
            throw new IllegalArgumentException("unexpected FIELD_NAME " + String.valueOf(parser.currentToken()));
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new IllegalArgumentException("expected the license object token at the end");
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new IllegalArgumentException("expected an object token at the end");
        }
        return new License(licenseKey);
    }

    private static String parseStringField(XContentParser parser) throws IOException {
        parser.nextToken();
        return parser.textOrNull();
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, WRITEABLE_TYPE, License::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, WRITEABLE_TYPE, in -> License.readDiffFrom(Metadata.Custom.class, WRITEABLE_TYPE, in)));
        return entries;
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Collections.singletonList(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField(WRITEABLE_TYPE, new String[0]), License::fromXContent));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License licenseKey = (License)o;
        return Objects.equals(this.licenseKey, licenseKey.licenseKey);
    }

    public int hashCode() {
        return Objects.hash(this.licenseKey);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY, Metadata.XContentContext.SNAPSHOT);
    }

    @Override
    public String getWriteableName() {
        return WRITEABLE_TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_1;
    }
}

