/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.CheckConstraint;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public interface RelationInfo
extends Iterable<Reference> {
    public static final String PK_SUFFIX = "_pkey";

    public Collection<Reference> columns();

    default public Collection<Reference> allColumns() {
        return this.columns();
    }

    default public Collection<Reference> droppedColumns() {
        return List.of();
    }

    default public int maxPosition() {
        return this.columns().stream().filter(ref -> !ref.column().isSystemColumn()).mapToInt(Reference::position).max().orElse(0);
    }

    public RowGranularity rowGranularity();

    public RelationName ident();

    @Nullable
    default public String pkConstraintName() {
        return null;
    }

    @Nullable
    default public String pkConstraintNameOrDefault() {
        String pkName = this.pkConstraintName();
        if (pkName != null) {
            return pkName;
        }
        if (this.primaryKey().isEmpty() || this.primaryKey().size() == 1 && this.primaryKey().get(0).isSystemColumn()) {
            return null;
        }
        return this.ident().name() + PK_SUFFIX;
    }

    public List<ColumnIdent> primaryKey();

    default public List<CheckConstraint<Symbol>> checkConstraints() {
        return List.of();
    }

    public Settings parameters();

    public Set<Operation> supportedOperations();

    public RelationType relationType();

    public static enum RelationType {
        BASE_TABLE("BASE TABLE"),
        VIEW("VIEW"),
        FOREIGN("FOREIGN");

        private final String prettyName;

        private RelationType(String prettyName) {
            this.prettyName = prettyName;
        }

        public String pretty() {
            return this.prettyName;
        }
    }
}

