/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import io.crate.blob.v2.BlobIndex;
import io.crate.exceptions.InvalidRelationName;
import io.crate.exceptions.InvalidSchemaNameException;
import io.crate.metadata.IndexName;
import io.crate.metadata.Schemas;
import io.crate.sql.Identifiers;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Table;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public final class RelationName
implements Writeable,
Accountable {
    private static final Set<String> INVALID_NAME_CHARACTERS = Set.of(".");
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(RelationName.class);
    @Nullable
    private final String schema;
    private final String name;

    public static RelationName of(QualifiedName name, String defaultSchema) {
        List parts = name.getParts();
        if (parts.size() > 3) {
            throw new IllegalArgumentException("Table with more than 3 QualifiedName parts is not supported. Only <catalog>.<schema>.<tableName> works.");
        }
        if (parts.size() == 3) {
            RelationName.ensureIsCrateCatalog((String)parts.get(0));
        }
        if (parts.size() >= 2) {
            return new RelationName((String)parts.get(parts.size() - 2), (String)parts.get(parts.size() - 1));
        }
        return new RelationName(defaultSchema, (String)parts.get(0));
    }

    public static RelationName fromBlobTable(Table<?> table) {
        List tableNameParts = table.getName().getParts();
        if (tableNameParts.size() > 2) {
            throw new IllegalArgumentException("Invalid tableName \"" + String.valueOf(table.getName()) + "\"");
        }
        if (tableNameParts.size() == 2) {
            if (!((String)tableNameParts.get(0)).equals("blob")) {
                throw new IllegalArgumentException("The Schema \"" + (String)tableNameParts.get(0) + "\" isn't valid in a [CREATE | ALTER] BLOB TABLE clause");
            }
            return new RelationName((String)tableNameParts.get(0), (String)tableNameParts.get(1));
        }
        assert (tableNameParts.size() == 1) : "tableNameParts.size() must be 1";
        return new RelationName("blob", (String)tableNameParts.get(0));
    }

    public static RelationName fromIndexName(String indexName) {
        return IndexName.decode(indexName).toRelationName();
    }

    public static String fqnFromIndexName(String indexName) {
        return IndexName.decode(indexName).toFullyQualifiedName();
    }

    public RelationName(StreamInput in) throws IOException {
        this.schema = in.getVersion().before(Version.V_4_2_0) ? in.readString() : in.readOptionalString();
        this.name = in.readString();
    }

    public RelationName(@Nullable String schema, String name) {
        assert (name != null) : "table name must not be null";
        if (schema != null && RelationName.isInvalidSchemaOrRelationName(schema)) {
            throw new InvalidSchemaNameException(schema);
        }
        if (RelationName.isInvalidSchemaOrRelationName(name)) {
            throw new InvalidRelationName((String)(schema == null ? name : schema + "." + name));
        }
        this.schema = schema;
        this.name = name;
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public String fqn() {
        if (this.schema == null) {
            return this.name;
        }
        return this.schema + "." + this.name;
    }

    public String sqlFqn() {
        if (this.schema == null) {
            return Identifiers.quoteIfNeeded((String)this.name);
        }
        return Identifiers.quoteIfNeeded((String)this.schema) + "." + Identifiers.quoteIfNeeded((String)this.name);
    }

    public QualifiedName toQualifiedName() {
        if (this.schema == null) {
            return new QualifiedName(this.name);
        }
        return new QualifiedName(List.of(this.schema, this.name));
    }

    public String indexNameOrAlias() {
        if (this.schema == null) {
            throw new IllegalStateException("indexNameOrAlias can only be generated from a RelationName that is fully qualified.");
        }
        if (this.schema.equals("doc")) {
            return this.name;
        }
        if (this.schema.equals("blob")) {
            return BlobIndex.fullIndexName(this.name);
        }
        return this.fqn();
    }

    public void ensureValidForRelationCreation() throws InvalidSchemaNameException, InvalidRelationName {
        if (Schemas.READ_ONLY_SYSTEM_SCHEMAS.contains(this.schema)) {
            throw new IllegalArgumentException("Cannot create relation in read-only schema: " + this.schema);
        }
        if (this.schema.equalsIgnoreCase("_all") || this.name.equalsIgnoreCase("_all")) {
            throw new IllegalArgumentException("\"_all\" cannot be used as schema or table name");
        }
    }

    public static void ensureIsCrateCatalog(String catalogName) {
        if (!"crate".equals(catalogName)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unexpected catalog name: %s. Only available catalog is %s", catalogName, "crate"));
        }
    }

    private static boolean isInvalidSchemaOrRelationName(String name) {
        return name.isEmpty() || RelationName.containsIllegalCharacters(name);
    }

    private static boolean containsIllegalCharacters(String name) {
        for (String illegalCharacter : INVALID_NAME_CHARACTERS) {
            if (!name.contains(illegalCharacter)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fqn();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_4_2_0)) {
            out.writeString(this.schema == null ? "doc" : this.schema);
        } else {
            out.writeOptionalString(this.schema);
        }
        out.writeString(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationName that = (RelationName)o;
        if (this.schema != null ? !this.schema.equals(that.schema) : that.schema != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.schema != null ? this.schema.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.schema) + RamUsageEstimator.sizeOf((String)this.name);
    }
}

