/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.discovery.MasterNotDiscoveredException;

public class Routing
implements Writeable {
    private final Map<String, Map<String, IntIndexedContainer>> locations;

    public Routing(Map<String, Map<String, IntIndexedContainer>> locations) {
        assert (locations != null) : "locations must not be null";
        assert (this.assertLocationsAllTreeMap(locations)) : "locations must be a TreeMap only and must contain only TreeMap's";
        this.locations = locations;
    }

    public Map<String, Map<String, IntIndexedContainer>> locations() {
        return this.locations;
    }

    public boolean hasLocations() {
        return this.locations.size() > 0;
    }

    public Set<String> nodes() {
        return this.locations.keySet();
    }

    public int numShards(String nodeId) {
        Map<String, IntIndexedContainer> indicesAndShards = this.locations.get(nodeId);
        if (indicesAndShards == null) {
            return 0;
        }
        int numShards = 0;
        for (IntIndexedContainer shardIds : indicesAndShards.values()) {
            numShards += shardIds.size();
        }
        return numShards;
    }

    public boolean containsShards(String nodeId) {
        Map<String, IntIndexedContainer> indicesAndShards = this.locations.get(nodeId);
        if (indicesAndShards == null) {
            return false;
        }
        for (IntIndexedContainer shardIds : indicesAndShards.values()) {
            if (shardIds.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean containsShards() {
        for (Map<String, IntIndexedContainer> indices : this.locations.values()) {
            for (IntIndexedContainer shards : indices.values()) {
                if (shards.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Routing{locations=" + String.valueOf(this.locations) + "}";
    }

    public Routing(StreamInput in) throws IOException {
        int numLocations = in.readVInt();
        if (numLocations == 0) {
            this.locations = Map.of();
        } else {
            this.locations = new TreeMap<String, Map<String, IntIndexedContainer>>();
            for (int i = 0; i < numLocations; ++i) {
                String nodeId = in.readString();
                int numInner = in.readVInt();
                TreeMap<String, IntArrayList> shardsByIndex = new TreeMap<String, IntArrayList>();
                this.locations.put(nodeId, shardsByIndex);
                for (int j = 0; j < numInner; ++j) {
                    String indexName = in.readString();
                    int numShards = in.readVInt();
                    IntArrayList shardIds = new IntArrayList(numShards);
                    for (int k = 0; k < numShards; ++k) {
                        shardIds.add(in.readVInt());
                    }
                    shardsByIndex.put(indexName, shardIds);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (Map.Entry<String, Map<String, IntIndexedContainer>> entry : this.locations.entrySet()) {
            out.writeString(entry.getKey());
            Map<String, IntIndexedContainer> shardsByIndex = entry.getValue();
            if (shardsByIndex == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(shardsByIndex.size());
            for (Map.Entry<String, IntIndexedContainer> innerEntry : shardsByIndex.entrySet()) {
                out.writeString(innerEntry.getKey());
                IntIndexedContainer shardIds = innerEntry.getValue();
                if (shardIds == null || shardIds.size() == 0) {
                    out.writeVInt(0);
                    continue;
                }
                out.writeVInt(shardIds.size());
                for (IntCursor shardId : shardIds) {
                    out.writeVInt(shardId.value);
                }
            }
        }
    }

    private boolean assertLocationsAllTreeMap(Map<String, Map<String, IntIndexedContainer>> locations) {
        if (locations.isEmpty()) {
            return true;
        }
        if (!(locations instanceof TreeMap) && locations.size() > 1) {
            return false;
        }
        for (Map<String, IntIndexedContainer> shardsByIndex : locations.values()) {
            if (shardsByIndex.size() <= 1 || shardsByIndex instanceof TreeMap) continue;
            return false;
        }
        return true;
    }

    public static Routing forTableOnSingleNode(RelationName relationName, String nodeId) {
        TreeMap<String, Map<String, IntIndexedContainer>> locations = new TreeMap<String, Map<String, IntIndexedContainer>>();
        TreeMap<String, IntArrayList> tableLocation = new TreeMap<String, IntArrayList>();
        tableLocation.put(relationName.fqn(), IntArrayList.from((int[])IntArrayList.EMPTY_ARRAY));
        locations.put(nodeId, tableLocation);
        return new Routing(locations);
    }

    public static Routing forTableOnAllNodes(RelationName relationName, DiscoveryNodes nodes) {
        TreeMap<String, Map<String, IntIndexedContainer>> indicesByNode = new TreeMap<String, Map<String, IntIndexedContainer>>();
        Map<String, IntArrayList> shardsByIndex = Collections.singletonMap(relationName.indexNameOrAlias(), IntArrayList.from((int[])IntArrayList.EMPTY_ARRAY));
        for (DiscoveryNode node : nodes) {
            indicesByNode.put(node.getId(), shardsByIndex);
        }
        return new Routing(indicesByNode);
    }

    public static Routing forMasterNode(RelationName relationName, ClusterState clusterState) {
        String masterNodeId = clusterState.nodes().getMasterNodeId();
        if (masterNodeId == null) {
            throw new MasterNotDiscoveredException();
        }
        return Routing.forTableOnSingleNode(relationName, masterNodeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Routing other = (Routing)o;
        return this.locations.equals(other.locations);
    }

    public int hashCode() {
        return this.locations.hashCode();
    }
}

