/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.cluster;

import io.crate.analyze.TableParameters;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.sql.tree.ColumnPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class AlterTableClusterStateExecutor
extends DDLClusterStateTaskExecutor<AlterTableRequest> {
    private static final IndicesOptions FIND_OPEN_AND_CLOSED_INDICES_IGNORE_UNAVAILABLE_AND_NON_EXISTING = IndicesOptions.fromOptions(true, true, true, true);
    private final IndexScopedSettings indexScopedSettings;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final NodeContext nodeContext;
    private final MetadataUpdateSettingsService updateSettingsService;

    public AlterTableClusterStateExecutor(IndicesService indicesService, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService metadataCreateIndexService, MetadataUpdateSettingsService updateSettingsService, NodeContext nodeContext) {
        this.indexScopedSettings = indexScopedSettings;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.nodeContext = nodeContext;
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected ClusterState execute(ClusterState currentState, AlterTableRequest request) throws Exception {
        String policy = request.settings().get(TableParameters.COLUMN_POLICY.getKey());
        ColumnPolicy columnPolicy = policy == null ? null : ColumnPolicy.of((String)policy);
        Settings.Builder settingsBuilder = Settings.builder().put(request.settings());
        settingsBuilder.remove(TableParameters.COLUMN_POLICY.getKey());
        Settings settings = settingsBuilder.build();
        if (request.isPartitioned()) {
            if (!request.partitionValues().isEmpty()) {
                for (Setting<?> tableOnlySetting : TableParameters.TABLE_ONLY_SETTINGS) {
                    if (!tableOnlySetting.exists(settings)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "\"%s\" cannot be changed on partition level", tableOnlySetting.getKey()));
                }
                String indexName = new PartitionName(request.tableIdent(), request.partitionValues()).asIndexName();
                Index[] concreteIndices = AlterTableClusterStateExecutor.resolveIndices(currentState, indexName);
                currentState = this.updateSettings(currentState, settings, concreteIndices);
            } else {
                Map<String, Object> newMapping = AlterTableClusterStateExecutor.settingsToMapping(request.settings());
                currentState = AlterTableClusterStateExecutor.updateTemplate(currentState, request.tableIdent(), settings, newMapping, (name, s) -> AlterTableClusterStateExecutor.validateSettings(name, s, this.indexScopedSettings, this.metadataCreateIndexService), this.indexScopedSettings);
                if (!request.excludePartitions()) {
                    Index[] concreteIndices = AlterTableClusterStateExecutor.resolveIndices(currentState, request.tableIdent().indexNameOrAlias());
                    List<Setting<?>> supportedSettings = TableParameters.PARTITIONED_TABLE_PARAMETER_INFO_FOR_TEMPLATE_UPDATE.supportedSettings().values().stream().collect(Collectors.toList());
                    supportedSettings.add(AutoExpandReplicas.SETTING);
                    currentState = this.updateSettings(currentState, AlterTableClusterStateExecutor.filterSettings(settings, supportedSettings), concreteIndices);
                    currentState = this.updateMapping(currentState, concreteIndices, columnPolicy);
                }
            }
        } else {
            Index[] concreteIndices = AlterTableClusterStateExecutor.resolveIndices(currentState, request.tableIdent().indexNameOrAlias());
            currentState = this.updateMapping(currentState, concreteIndices, columnPolicy);
            currentState = this.updateSettings(currentState, settings, concreteIndices);
        }
        new DocTableInfoFactory(this.nodeContext).create(request.tableIdent(), currentState.metadata());
        return currentState;
    }

    private ClusterState updateMapping(ClusterState currentState, Index[] concreteIndices, @Nullable ColumnPolicy columnPolicy) throws IOException {
        if (columnPolicy == null) {
            return currentState;
        }
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        for (Index index : concreteIndices) {
            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
            Map<String, Object> indexMapping = indexMetadata.mapping().sourceAsMap();
            String mappingValue = columnPolicy.toMappingValue();
            if (indexMapping.get("dynamic").equals(mappingValue)) {
                return currentState;
            }
            indexMapping.put("dynamic", mappingValue);
            IndexMetadata.Builder imBuilder = IndexMetadata.builder(indexMetadata);
            imBuilder.putMapping(new MappingMetadata(indexMapping)).mappingVersion(1L + imBuilder.mappingVersion());
            metadataBuilder.put(imBuilder);
        }
        return ClusterState.builder(currentState).metadata(metadataBuilder).build();
    }

    private ClusterState updateSettings(ClusterState currentState, Settings settings, Index[] concreteIndices) {
        Settings normalizedSettings = Settings.builder().put(AlterTableClusterStateExecutor.markArchivedSettings(settings)).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        HashSet<String> skippedSettings = new HashSet<String>();
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key.replace("index.", ""));
        }
        Settings closedSettings = settingsForClosedIndices.build();
        Settings openSettings = settingsForOpenIndices.build();
        return this.updateSettingsService.updateState(currentState, concreteIndices, skippedSettings, closedSettings, openSettings);
    }

    public static Map<String, Object> settingsToMapping(Settings settings) {
        String policy = settings.get(TableParameters.COLUMN_POLICY.getKey());
        if (policy == null) {
            return Map.of();
        }
        return Map.of("dynamic", ColumnPolicy.of((String)policy).toMappingValue());
    }

    static ClusterState updateTemplate(ClusterState currentState, RelationName relationName, Settings newSetting, Map<String, Object> newMapping, BiConsumer<String, Settings> settingsValidator, IndexScopedSettings indexScopedSettings) throws IOException {
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        IndexTemplateMetadata indexTemplateMetadata = currentState.metadata().templates().get(templateName);
        IndexTemplateMetadata newIndexTemplateMetadata = DDLClusterStateHelpers.updateTemplate(indexTemplateMetadata, newMapping, Collections.emptyMap(), newSetting, indexScopedSettings);
        Metadata.Builder metadata = Metadata.builder(currentState.metadata()).put(newIndexTemplateMetadata);
        return ClusterState.builder(currentState).metadata(metadata).build();
    }

    private static void validateSettings(String name, Settings settings, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService metadataCreateIndexService) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        try {
            indexScopedSettings.validate(settings, true);
        }
        catch (IllegalArgumentException iae) {
            validationErrors.add(iae.getMessage());
            for (Throwable t : iae.getSuppressed()) {
                validationErrors.add(t.getMessage());
            }
        }
        List<String> indexSettingsValidation = metadataCreateIndexService.getIndexSettingsValidationErrors(settings, true);
        validationErrors.addAll(indexSettingsValidation);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new InvalidIndexTemplateException(name, validationException.getMessage());
        }
    }

    @VisibleForTesting
    static Settings filterSettings(Settings settings, List<Setting<?>> settingsFilter) {
        Settings.Builder settingsBuilder = Settings.builder();
        Set<String> settingNames = settings.keySet();
        for (Setting<?> setting : settingsFilter) {
            String key = setting.getKey();
            if (setting.isGroupSetting()) {
                Settings settingsGroup = settings.getByPrefix(key);
                for (String name : settingsGroup.keySet()) {
                    settingsBuilder.put(key + name, settingsGroup.get(name));
                }
                continue;
            }
            if (!settingNames.contains(key)) continue;
            settingsBuilder.put(key, settings.get(key));
        }
        return settingsBuilder.build();
    }

    public static Index[] resolveIndices(ClusterState currentState, String indexExpressions) {
        return IndexNameExpressionResolver.concreteIndices(currentState.metadata(), FIND_OPEN_AND_CLOSED_INDICES_IGNORE_UNAVAILABLE_AND_NON_EXISTING, indexExpressions);
    }

    @VisibleForTesting
    static Settings markArchivedSettings(Settings settings) {
        return Settings.builder().put(settings).putNull("archived.*").build();
    }
}

