/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.functions;

import io.crate.common.collections.EnumSets;
import io.crate.common.collections.Lists;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.SignatureBindingInfo;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public final class Signature
implements Writeable,
Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Signature.class);
    private final FunctionName name;
    private final FunctionType type;
    private final List<TypeSignature> argumentTypes;
    private final TypeSignature returnType;
    private final Set<Scalar.Feature> features;
    @Nullable
    private final SignatureBindingInfo bindingInfo;

    public static Builder builder(FunctionName name, FunctionType type) {
        return new Builder().name(name).type(type);
    }

    public static Builder builder(String name, FunctionType type) {
        return new Builder().name(name).type(type);
    }

    public static Builder builder(Signature signature) {
        return new Builder(signature);
    }

    public static Signature readFromFunctionInfo(StreamInput in) throws IOException {
        FunctionName functionName = new FunctionName(in);
        int numTypes = in.readVInt();
        ArrayList<TypeSignature> argumentTypeSignatures = new ArrayList<TypeSignature>(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            argumentTypeSignatures.add(DataTypes.fromStream(in).getTypeSignature());
        }
        DataType<?> returnType = DataTypes.fromStream(in);
        FunctionType type = FunctionType.values()[in.readVInt()];
        int enumElements = in.readVInt();
        Set<Scalar.Feature> features = Collections.unmodifiableSet(EnumSets.unpackFromInt((int)enumElements, Scalar.Feature.class));
        return Signature.builder(functionName, type).argumentTypes(argumentTypeSignatures).returnType(returnType.getTypeSignature()).features(features).build();
    }

    private Signature(FunctionName name, FunctionType type, List<TypeVariableConstraint> typeVariableConstraints, List<TypeSignature> argumentTypes, TypeSignature returnType, Set<Scalar.Feature> features, List<TypeSignature> variableArityGroup, boolean variableArity, boolean allowCoercion) {
        this.name = name;
        this.type = type;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.features = features;
        this.bindingInfo = new SignatureBindingInfo(typeVariableConstraints, variableArityGroup, variableArity, allowCoercion);
    }

    public Signature(StreamInput in) throws IOException {
        this.name = new FunctionName(in);
        this.type = FunctionType.values()[in.readVInt()];
        int argsSize = in.readVInt();
        this.argumentTypes = new ArrayList<TypeSignature>(argsSize);
        for (int i = 0; i < argsSize; ++i) {
            this.argumentTypes.add(TypeSignature.fromStream(in));
        }
        this.returnType = TypeSignature.fromStream(in);
        int enumElements = in.readVInt();
        this.features = Collections.unmodifiableSet(EnumSets.unpackFromInt((int)enumElements, Scalar.Feature.class));
        this.bindingInfo = null;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + this.name.ramBytesUsed() + this.argumentTypes.stream().mapToLong(TypeSignature::ramBytesUsed).sum() + this.returnType.ramBytesUsed();
    }

    public FunctionName getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public List<DataType<?>> getArgumentDataTypes() {
        return Lists.map(this.argumentTypes, TypeSignature::createType);
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public Set<Scalar.Feature> getFeatures() {
        return this.features;
    }

    public boolean hasFeature(Scalar.Feature feature) {
        return this.features.contains((Object)feature);
    }

    public boolean isDeterministic() {
        return this.hasFeature(Scalar.Feature.DETERMINISTIC);
    }

    @Nullable
    public SignatureBindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.name.writeTo(out);
        out.writeVInt(this.type.ordinal());
        out.writeVInt(this.argumentTypes.size());
        for (TypeSignature typeSignature : this.argumentTypes) {
            TypeSignature.toStream(typeSignature, out);
        }
        TypeSignature.toStream(this.returnType, out);
        out.writeVInt(EnumSets.packToInt(this.features));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Signature)) return false;
        Signature signature = (Signature)o;
        if (!this.name.equals(signature.name)) return false;
        if (this.type != signature.type) return false;
        if (!this.argumentTypes.equals(signature.argumentTypes)) return false;
        if (!this.returnType.equals(signature.returnType)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.argumentTypes.hashCode();
        result = 31 * result + this.returnType.hashCode();
        return result;
    }

    public String toString() {
        List allConstraints = List.of();
        if (this.bindingInfo != null) {
            allConstraints = Lists.map(this.bindingInfo.getTypeVariableConstraints(), TypeVariableConstraint::toString);
        }
        return String.valueOf(this.name) + (String)(allConstraints.isEmpty() ? "" : "<" + String.join((CharSequence)",", allConstraints) + ">") + "(" + Lists.joinOn((String)",", this.argumentTypes, TypeSignature::toString) + "):" + String.valueOf(this.returnType);
    }

    public void writeAsFunctionInfo(StreamOutput out, List<DataType<?>> argumentDataTypes) throws IOException {
        this.name.writeTo(out);
        out.writeVInt(argumentDataTypes.size());
        for (DataType<?> argumentType : argumentDataTypes) {
            DataTypes.toStream(argumentType, out);
        }
        DataTypes.toStream(this.returnType.createType(), out);
        out.writeVInt(this.type.ordinal());
        out.writeVInt(EnumSets.packToInt(this.features));
    }

    public static class Builder {
        private FunctionName name;
        private FunctionType type;
        private List<TypeSignature> argumentTypes = Collections.emptyList();
        private TypeSignature returnType;
        private Set<Scalar.Feature> features = Set.of();
        private List<TypeVariableConstraint> typeVariableConstraints = Collections.emptyList();
        private List<TypeSignature> variableArityGroup = Collections.emptyList();
        private boolean variableArity = false;
        private boolean allowCoercion = true;

        public Builder() {
        }

        public Builder(Signature signature) {
            this.name = signature.getName();
            this.type = signature.getType();
            this.argumentTypes = signature.getArgumentTypes();
            this.returnType = signature.getReturnType();
            this.features = signature.getFeatures();
            if (signature.getBindingInfo() != null) {
                this.typeVariableConstraints = signature.getBindingInfo().getTypeVariableConstraints();
                this.variableArityGroup = signature.getBindingInfo().getVariableArityGroup();
                this.variableArity = signature.getBindingInfo().isVariableArity();
                this.allowCoercion = signature.getBindingInfo().isCoercionAllowed();
            }
        }

        public Builder name(String name) {
            return this.name(new FunctionName(null, name));
        }

        public Builder name(FunctionName name) {
            this.name = name;
            return this;
        }

        public Builder type(FunctionType type) {
            this.type = type;
            return this;
        }

        public Builder argumentTypes(TypeSignature ... argumentTypes) {
            return this.argumentTypes(List.of(argumentTypes));
        }

        public Builder argumentTypes(List<TypeSignature> argumentTypes) {
            this.argumentTypes = argumentTypes;
            return this;
        }

        public Builder returnType(TypeSignature returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder features(Set<Scalar.Feature> features) {
            this.features = features;
            return this;
        }

        public Builder features(Scalar.Feature feature, Scalar.Feature ... rest) {
            this.features = EnumSet.of(feature, rest);
            return this;
        }

        public Builder features(Scalar.Feature feature) {
            this.features = EnumSet.of(feature);
            return this;
        }

        public Builder typeVariableConstraints(TypeVariableConstraint ... typeVariableConstraints) {
            return this.typeVariableConstraints(List.of(typeVariableConstraints));
        }

        public Builder typeVariableConstraints(List<TypeVariableConstraint> typeVariableConstraints) {
            this.typeVariableConstraints = typeVariableConstraints;
            return this;
        }

        public Builder variableArityGroup(List<TypeSignature> variableArityGroup) {
            this.variableArityGroup = variableArityGroup;
            this.variableArity = !variableArityGroup.isEmpty();
            return this;
        }

        public Builder setVariableArity(boolean variableArity) {
            this.variableArity = variableArity;
            return this;
        }

        public Builder forbidCoercion() {
            this.allowCoercion = false;
            return this;
        }

        public Signature build() {
            assert (this.name != null) : "Signature requires the 'name' to be set";
            assert (this.type != null) : "Signature requires the 'type' to be set";
            assert (this.returnType != null) : "Signature requires the 'returnType' to be set";
            return new Signature(this.name, this.type, this.typeVariableConstraints, this.argumentTypes, this.returnType, this.features, this.variableArityGroup, this.variableArity, this.allowCoercion);
        }
    }
}

