/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.pgcatalog;

import io.crate.exceptions.MissingPrivilegeException;
import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.role.Permission;
import io.crate.role.Privileges;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.crate.role.Securable;
import io.crate.types.DataType;
import io.crate.types.DataTypes;

public final class PgRolesTable {
    public static final RelationName IDENT = new RelationName("pg_catalog", "pg_roles");

    private PgRolesTable() {
    }

    public static SystemTable<Role> create(Roles roles) {
        return ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("rolname", (DataType)DataTypes.STRING, Role::name)).add("rolsuper", (DataType)DataTypes.BOOLEAN, Role::isSuperUser)).add("rolinherit", (DataType)DataTypes.BOOLEAN, r -> true)).add("rolcreaterole", (DataType)DataTypes.BOOLEAN, r -> PgRolesTable.canCreateRoleOrSubscription(roles, r))).add("rolcreatedb", (DataType)DataTypes.BOOLEAN, ignored -> null)).add("rolcanlogin", (DataType)DataTypes.BOOLEAN, Role::isUser)).add("rolreplication", (DataType)DataTypes.BOOLEAN, r -> PgRolesTable.canCreateRoleOrSubscription(roles, r))).add("rolconnlimit", (DataType)DataTypes.INTEGER, r -> -1)).add("rolpassword", (DataType)DataTypes.STRING, r -> r.password() != null ? "********" : null)).add("rolvaliduntil", (DataType)DataTypes.TIMESTAMPZ, ignored -> null)).add("rolbypassrls", (DataType)DataTypes.BOOLEAN, ignored -> null)).add("rolconfig", DataTypes.STRING_ARRAY, ignored -> null)).add("oid", (DataType)DataTypes.INTEGER, r -> OidHash.userOid(r.name()))).build();
    }

    private static boolean canCreateRoleOrSubscription(Roles roles, Role role) {
        try {
            Privileges.ensureUserHasPrivilege(roles, role, Permission.AL, Securable.CLUSTER, null);
            return true;
        }
        catch (MissingPrivilegeException e) {
            return false;
        }
    }
}

