/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.SearchPath;
import io.crate.metadata.settings.SessionSettings;
import io.crate.planner.optimizer.LoadedRules;
import io.crate.planner.optimizer.Rule;
import io.crate.role.Role;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CoordinatorSessionSettings
extends SessionSettings {
    private final Role authenticatedUser;
    private Role sessionUser;
    private final Set<Class<? extends Rule<?>>> excludedOptimizerRules;
    private String applicationName;
    private String dateStyle;
    private TimeValue statementTimeout;

    public CoordinatorSessionSettings(Role authenticatedUser, String ... searchPath) {
        this(authenticatedUser, authenticatedUser, Set.of(), searchPath);
    }

    public CoordinatorSessionSettings(Role authenticatedUser, Role sessionUser, String ... searchPath) {
        this(authenticatedUser, sessionUser, Set.of(), searchPath);
    }

    public CoordinatorSessionSettings(Role authenticatedUser, Role sessionUser, Set<Class<? extends Rule<?>>> excludedOptimizerRules, String ... searchPath) {
        this(authenticatedUser, sessionUser, SearchPath.createSearchPathFrom(searchPath), true, excludedOptimizerRules, true, 0);
    }

    public CoordinatorSessionSettings(Role authenticatedUser, Role sessionUser, SearchPath searchPath, boolean hashJoinsEnabled, Set<Class<? extends Rule<?>>> excludedOptimizerRules, boolean errorOnUnknownObjectKey, int memoryLimit) {
        super(authenticatedUser.name(), searchPath, hashJoinsEnabled, errorOnUnknownObjectKey, memoryLimit);
        this.authenticatedUser = authenticatedUser;
        this.sessionUser = sessionUser;
        this.excludedOptimizerRules = new HashSet(excludedOptimizerRules);
        this.dateStyle = "ISO";
        this.statementTimeout = TimeValue.ZERO;
    }

    public Role sessionUser() {
        return this.sessionUser;
    }

    public Role authenticatedUser() {
        return this.authenticatedUser;
    }

    public static CoordinatorSessionSettings systemDefaults() {
        return new CoordinatorSessionSettings(Role.CRATE_USER, Role.CRATE_USER, LoadedRules.INSTANCE.disabledRules(), new String[0]);
    }

    public void setErrorOnUnknownObjectKey(boolean newValue) {
        this.errorOnUnknownObjectKey = newValue;
    }

    public void setSearchPath(String ... schemas) {
        this.searchPath = SearchPath.createSearchPathFrom(schemas);
    }

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    public void setHashJoinEnabled(boolean newValue) {
        this.hashJoinsEnabled = newValue;
    }

    public void setSessionUser(Role user) {
        this.sessionUser = user;
        this.userName = user.name();
    }

    public Set<Class<? extends Rule<?>>> excludedOptimizerRules() {
        return this.excludedOptimizerRules;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String applicationName() {
        return this.applicationName;
    }

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    @Override
    public String dateStyle() {
        return this.dateStyle;
    }

    @Override
    public TimeValue statementTimeout() {
        return this.statementTimeout;
    }

    public void statementTimeout(TimeValue statementTimeout) {
        this.statementTimeout = statementTimeout;
    }

    public Map<String, Object> toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("enable_hashjoin", this.hashJoinsEnabled);
        map.put("search_path", StreamSupport.stream(this.searchPath.spliterator(), false).collect(Collectors.joining(",")));
        map.put("error_on_unknown_object_key", this.errorOnUnknownObjectKey);
        map.put("datestyle", this.dateStyle);
        map.put("application_name", this.applicationName);
        map.put("memory.operation_limit", this.memoryLimit);
        map.put("statement_timeout", this.statementTimeout.toString());
        map.put("disabled_optimizer_rules", this.excludedOptimizerRules.stream().sorted(Comparator.comparing(Class::getSimpleName)).map(Rule::sessionSettingName).collect(Collectors.joining(",")));
        return map;
    }
}

