/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.shard.unassigned;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.Index;

public final class UnassignedShard {
    private final String schemaName;
    private final String tableName;
    private final Boolean primary;
    private final int id;
    private final String partitionIdent;
    private final String state;
    private final boolean orphanedPartition;
    private final String partitionUUID;
    private static final String UNASSIGNED = "UNASSIGNED";
    private static final String INITIALIZING = "INITIALIZING";

    public static boolean isUnassigned(int shardId) {
        return shardId < 0;
    }

    public static int markUnassigned(int id) {
        if (id >= 0) {
            return (id + 1) * -1;
        }
        return id;
    }

    public static int markAssigned(int shard) {
        if (shard < 0) {
            return shard * -1 - 1;
        }
        return shard;
    }

    public UnassignedShard(int shardId, Index index, ClusterService clusterService, Boolean primary, ShardRoutingState state) {
        IndexParts indexParts = IndexName.decode(index.getName());
        this.schemaName = indexParts.schema();
        this.tableName = indexParts.table();
        this.partitionIdent = indexParts.partitionIdent();
        this.orphanedPartition = indexParts.isPartitioned() && !clusterService.state().metadata().hasConcreteIndex(this.tableName);
        this.primary = primary;
        this.id = shardId;
        this.state = state == ShardRoutingState.UNASSIGNED ? UNASSIGNED : INITIALIZING;
        this.partitionUUID = index.getUUID();
    }

    public String tableName() {
        return this.tableName;
    }

    public int id() {
        return this.id;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String partitionIdent() {
        return this.partitionIdent;
    }

    public String partitionUUID() {
        return this.partitionUUID;
    }

    public Boolean primary() {
        return this.primary;
    }

    public String state() {
        return this.state;
    }

    public Boolean orphanedPartition() {
        return this.orphanedPartition;
    }
}

