/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.table;

import io.crate.analyze.WhereClause;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.elasticsearch.cluster.ClusterState;
import org.jetbrains.annotations.Nullable;

public interface TableInfo
extends RelationInfo {
    public static final Predicate<DataType<?>> IS_OBJECT_ARRAY = type -> type instanceof ArrayType && ArrayType.unnest(type).id() == 12;

    @Nullable
    public Reference getReference(ColumnIdent var1);

    @Nullable
    default public Reference getReadReference(ColumnIdent columnIdent) {
        Reference ref = this.getReference(columnIdent);
        if (ref == null) {
            return null;
        }
        DataType<?> readType = this.getReadType(columnIdent);
        if (readType.equals(ref.valueType())) {
            return ref;
        }
        return new SimpleReference(ref.ident(), ref.granularity(), readType, ref.indexType(), ref.isNullable(), ref.hasDocValues(), ref.position(), ref.oid(), ref.isDropped(), ref.defaultExpression());
    }

    default public Iterable<Reference> getParents(final ColumnIdent column) {
        if (column.isRoot()) {
            return Collections.emptyList();
        }
        return () -> new Iterator<Reference>(){
            ColumnIdent current;
            final /* synthetic */ TableInfo this$0;
            {
                this.this$0 = this$0;
                this.current = column;
            }

            @Override
            public boolean hasNext() {
                return !this.current.isRoot();
            }

            @Override
            public Reference next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Column has no more parent");
                }
                this.current = this.current.getParent();
                return this.this$0.getReference(this.current);
            }
        };
    }

    default public DataType<?> getReadType(ColumnIdent column) {
        Reference ref = this.getReference(column);
        if (ref == null) {
            return DataTypes.UNDEFINED;
        }
        int arrayDimensions = 0;
        for (Reference parent : this.getParents(column)) {
            if (!IS_OBJECT_ARRAY.test(parent.valueType())) continue;
            arrayDimensions += ArrayType.dimensions(parent.valueType());
        }
        return ArrayType.makeArray(ref.valueType(), arrayDimensions);
    }

    public Routing getRouting(ClusterState var1, RoutingProvider var2, WhereClause var3, RoutingProvider.ShardSelection var4, CoordinatorSessionSettings var5);
}

