/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import io.crate.common.collections.Maps;
import io.crate.metadata.upgrade.IndexTemplateUpgrader;
import io.crate.server.xcontent.XContentHelper;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetadataIndexUpgrader
implements BiFunction<IndexMetadata, IndexTemplateMetadata, IndexMetadata> {
    private final Logger logger = LogManager.getLogger(MetadataIndexUpgrader.class);

    @Override
    public IndexMetadata apply(IndexMetadata indexMetadata, IndexTemplateMetadata indexTemplateMetadata) {
        return this.createUpdatedIndexMetadata(indexMetadata, indexTemplateMetadata);
    }

    private IndexMetadata createUpdatedIndexMetadata(IndexMetadata indexMetadata, @Nullable IndexTemplateMetadata indexTemplateMetadata) {
        return IndexMetadata.builder(indexMetadata).putMapping(this.createUpdatedIndexMetadata(indexMetadata.mapping(), indexMetadata.getIndex().getName(), indexTemplateMetadata)).build();
    }

    @VisibleForTesting
    MappingMetadata createUpdatedIndexMetadata(MappingMetadata mappingMetadata, String indexName, @Nullable IndexTemplateMetadata indexTemplateMetadata) {
        if (mappingMetadata == null) {
            return null;
        }
        Map<String, Object> oldMapping = mappingMetadata.sourceAsMap();
        MetadataIndexUpgrader.removeInvalidPropertyGeneratedByDroppingSysCols(oldMapping);
        this.upgradeColumnPositions(oldMapping, indexTemplateMetadata);
        MetadataIndexUpgrader.upgradeIndexColumnMapping(oldMapping, indexTemplateMetadata);
        LinkedHashMap<String, Object> newMapping = new LinkedHashMap<String, Object>(oldMapping.size());
        block10: for (Map.Entry<String, Object> entry : oldMapping.entrySet()) {
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            switch (fieldName) {
                case "dynamic_templates": {
                    continue block10;
                }
                case "_all": {
                    continue block10;
                }
            }
            newMapping.put(fieldName, fieldNode);
        }
        try {
            return new MappingMetadata(Map.of("default", newMapping));
        }
        catch (IOException e) {
            this.logger.error("Failed to upgrade mapping for index '" + indexName + "'", (Throwable)e);
            return mappingMetadata;
        }
    }

    public static boolean addIndexColumnSources(Map<String, Object> rootMapping, Map<String, Object> currentMapping, String currentPath) {
        Map propertiesMap = (Map)Maps.get(currentMapping, (String)"properties");
        if (propertiesMap == null) {
            return false;
        }
        boolean updated = false;
        for (Map.Entry entry : propertiesMap.entrySet()) {
            String type;
            String columnName = (String)entry.getKey();
            String columnFQN = currentPath.isEmpty() ? columnName : currentPath + "." + columnName;
            Map columnProperties = (Map)entry.getValue();
            List indices = (List)Maps.get((Map)columnProperties, (String)"copy_to");
            if (indices != null) {
                updated = true;
                for (String index : indices) {
                    Map indexProps = (Map)Maps.get(rootMapping, (String)index);
                    ArrayList<String> sources = (ArrayList<String>)Maps.get((Map)indexProps, (String)"sources");
                    if (sources == null) {
                        sources = new ArrayList<String>();
                        indexProps.put("sources", sources);
                    }
                    sources.add(columnFQN);
                }
                columnProperties.remove("copy_to");
            }
            if ("array".equals(type = (String)Maps.get((Map)columnProperties, (String)"type"))) {
                Map innerMapping = (Map)Maps.get((Map)columnProperties, (String)"inner");
                String innerType = (String)Maps.get((Map)innerMapping, (String)"type");
                if (innerType != null && !ObjectType.UNTYPED.equals(DataTypes.ofMappingName(innerType))) continue;
                updated |= MetadataIndexUpgrader.addIndexColumnSources(rootMapping, innerMapping, columnFQN);
                continue;
            }
            if (type != null && !ObjectType.UNTYPED.equals(DataTypes.ofMappingName(type))) continue;
            updated |= MetadataIndexUpgrader.addIndexColumnSources(rootMapping, columnProperties, columnFQN);
        }
        return updated;
    }

    public static boolean removeInvalidPropertyGeneratedByDroppingSysCols(Map<String, Object> defaultMapping) {
        String droppedUnassigned;
        Map properties = (Map)Maps.get(defaultMapping, (String)"properties");
        if (properties != null && properties.containsKey(droppedUnassigned = "_dropped_" + Metadata.COLUMN_OID_UNASSIGNED)) {
            properties.remove(droppedUnassigned);
            return true;
        }
        return false;
    }

    static void upgradeIndexColumnMapping(Map<String, Object> oldMapping, @Nullable IndexTemplateMetadata indexTemplateMetadata) {
        MetadataIndexUpgrader.addIndexColumnSources((Map)Maps.get(oldMapping, (String)"properties"), oldMapping, "");
        if (indexTemplateMetadata != null) {
            Map<String, Object> parsedTemplateMapping = XContentHelper.convertToMap(indexTemplateMetadata.mapping().compressedReference(), true, XContentType.JSON).map();
            MetadataIndexUpgrader.addIndexColumnSources((Map)Maps.get(parsedTemplateMapping, (String)"properties"), parsedTemplateMapping, "");
        }
    }

    private void upgradeColumnPositions(Map<String, Object> defaultMap, @Nullable IndexTemplateMetadata indexTemplateMetadata) {
        if (indexTemplateMetadata != null) {
            MetadataIndexUpgrader.populateColumnPositionsFromMapping(defaultMap, indexTemplateMetadata.mapping());
        } else {
            IndexTemplateUpgrader.populateColumnPositions(defaultMap);
        }
    }

    public static void populateColumnPositionsFromMapping(Map<String, Object> mapping, CompressedXContent mappingToReference) {
        Map<String, Object> parsedTemplateMapping = XContentHelper.convertToMap(mappingToReference.compressedReference(), true, XContentType.JSON).map();
        MetadataIndexUpgrader.populateColumnPositionsImpl((Map)Maps.getOrDefault(mapping, (String)"default", mapping), (Map)Maps.getOrDefault(parsedTemplateMapping, (String)"default", parsedTemplateMapping));
    }

    @VisibleForTesting
    static void populateColumnPositionsImpl(Map<String, Object> indexMapping, Map<String, Object> templateMapping) {
        Map indexProperties = (Map)Maps.get(indexMapping, (String)"properties");
        if (indexProperties == null) {
            return;
        }
        Map templateProperties = (Map)Maps.get(templateMapping, (String)"properties");
        if (templateProperties == null) {
            templateProperties = Map.of();
        }
        for (Map.Entry e : indexProperties.entrySet()) {
            String key = (String)e.getKey();
            Map indexColumnProperties = (Map)e.getValue();
            Map templateColumnProperties = (Map)templateProperties.get(key);
            if (templateColumnProperties == null) {
                templateColumnProperties = Map.of();
            }
            templateColumnProperties = (Map)Maps.getOrDefault(templateColumnProperties, (String)"inner", templateColumnProperties);
            indexColumnProperties = (Map)Maps.getOrDefault((Map)indexColumnProperties, (String)"inner", (Object)indexColumnProperties);
            Integer templateChildPosition = (Integer)templateColumnProperties.get("position");
            assert (templateColumnProperties.containsKey("position") && templateChildPosition != null) : "the template mapping is missing column positions";
            if (templateChildPosition != null) {
                indexColumnProperties.put("position", templateChildPosition);
            }
            MetadataIndexUpgrader.populateColumnPositionsImpl(indexColumnProperties, templateColumnProperties);
        }
    }
}

