/*
 * Decompiled with CFR 0.152.
 */
package io.crate.monitor;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;

public class ExtendedNetworkInfo {
    public static final Interface NA_INTERFACE = new Interface("", "");
    private final Interface primary;

    public ExtendedNetworkInfo(Interface primary) {
        this.primary = primary;
    }

    public Interface primaryInterface() {
        return this.primary;
    }

    static Interface iface() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                byte[] addr = iface.getHardwareAddress();
                if (!iface.isUp() || addr == null) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < addr.length; ++i) {
                    sb.append(String.format(Locale.ROOT, "%02x", addr[i]));
                    if (i >= addr.length - 1) continue;
                    sb.append("-");
                }
                return new Interface(iface.getName(), sb.toString().toLowerCase(Locale.ROOT));
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return NA_INTERFACE;
    }

    public static class Interface {
        private final String name;
        private final String macAddress;

        Interface(String name, String macAddress) {
            this.name = name;
            this.macAddress = macAddress;
        }

        public String name() {
            return this.name;
        }

        public String macAddress() {
            return this.macAddress;
        }
    }
}

