/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public final class ReaderAllocations {
    private final TreeMap<Integer, String> readerIndices = new TreeMap();
    private final Map<String, IntSet> nodeReaders = new HashMap<String, IntSet>();
    private final TreeMap<String, Integer> bases;
    private final Map<RelationName, Collection<String>> tableIndices;
    private final Map<String, RelationName> indicesToIdents;

    ReaderAllocations(TreeMap<String, Integer> bases, Map<String, Map<Integer, String>> shardNodes, Map<RelationName, Collection<String>> tableIndices) {
        this.bases = bases;
        this.tableIndices = tableIndices;
        this.indicesToIdents = new HashMap<String, RelationName>(tableIndices.values().size());
        for (Map.Entry<RelationName, Collection<String>> entry : tableIndices.entrySet()) {
            for (String index : entry.getValue()) {
                this.indicesToIdents.put(index, entry.getKey());
            }
        }
        for (Map.Entry<Object, Object> entry : bases.entrySet()) {
            this.readerIndices.put((Integer)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : shardNodes.entrySet()) {
            Integer base = bases.get(entry.getKey());
            if (base == null) continue;
            for (Map.Entry nodeEntries : ((Map)entry.getValue()).entrySet()) {
                int readerId = base + (Integer)nodeEntries.getKey();
                IntSet readerIds = this.nodeReaders.get(nodeEntries.getValue());
                if (readerIds == null) {
                    readerIds = new IntHashSet();
                    this.nodeReaders.put((String)nodeEntries.getValue(), readerIds);
                }
                readerIds.add(readerId);
            }
        }
    }

    public Map<RelationName, Collection<String>> tableIndices() {
        return this.tableIndices;
    }

    public TreeMap<Integer, String> indices() {
        return this.readerIndices;
    }

    public Map<String, IntSet> nodeReaders() {
        return this.nodeReaders;
    }

    public TreeMap<String, Integer> bases() {
        return this.bases;
    }

    public Map<String, RelationName> indicesToIdents() {
        return this.indicesToIdents;
    }
}

