/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateBlobTable;
import io.crate.analyze.NumberOfShards;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.TableParameters;
import io.crate.analyze.TableProperties;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.ddl.tables.CreateBlobTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.execution.ddl.tables.TransportCreateBlobTableAction;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.NumberOfReplicas;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CreateBlobTable;
import io.crate.sql.tree.GenericProperties;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public class CreateBlobTablePlan
implements Plan {
    private final AnalyzedCreateBlobTable analyzedBlobTable;
    private final NumberOfShards numberOfShards;

    public CreateBlobTablePlan(AnalyzedCreateBlobTable analyzedBlobTable, NumberOfShards numberOfShards) {
        this.analyzedBlobTable = analyzedBlobTable;
        this.numberOfShards = numberOfShards;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        RelationName relationName = this.analyzedBlobTable.relationName();
        Settings settings = CreateBlobTablePlan.buildSettings(this.analyzedBlobTable.createBlobTable(), plannerContext.transactionContext(), dependencies.nodeContext(), params, subQueryResults, this.numberOfShards);
        if (plannerContext.clusterState().nodes().getSmallestNonClientNodeVersion().onOrAfter(Version.V_5_10_0)) {
            CreateBlobTableRequest request = new CreateBlobTableRequest(relationName, settings);
            OneRowActionListener<CreateTableResponse> listener = new OneRowActionListener<CreateTableResponse>(consumer, ignoredResponse -> new Row1((Object)1L));
            dependencies.client().execute(TransportCreateBlobTableAction.ACTION, request).whenComplete(listener);
        } else {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(relationName.indexNameOrAlias(), settings);
            OneRowActionListener<CreateIndexResponse> listener = new OneRowActionListener<CreateIndexResponse>(consumer, ignoredResponse -> new Row1((Object)1L));
            dependencies.client().execute(CreateIndexAction.INSTANCE, createIndexRequest).whenComplete(listener);
        }
    }

    @VisibleForTesting
    public static Settings buildSettings(CreateBlobTable<Symbol> createBlobTable, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row params, SubQueryResults subQueryResults, NumberOfShards numberOfShards) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, params, subQueryResults);
        CreateBlobTable blobTable = createBlobTable.map(eval);
        GenericProperties properties = blobTable.genericProperties();
        Settings.Builder builder = Settings.builder();
        builder.put(NumberOfReplicas.SETTING.getDefault(Settings.EMPTY));
        TableProperties.analyze(builder, TableParameters.CREATE_BLOB_TABLE_PARAMETERS, (GenericProperties<Object>)properties);
        builder.put(BlobIndicesService.SETTING_INDEX_BLOBS_ENABLED.getKey(), true);
        ClusteredBy clusteredBy = blobTable.clusteredBy();
        int numShards = clusteredBy != null ? numberOfShards.fromClusteredByClause((ClusteredBy<Object>)clusteredBy) : numberOfShards.defaultNumberOfShards();
        builder.put("index.number_of_shards", numShards);
        return builder.build();
    }
}

