/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.ddl;

import io.crate.analyze.AnalyzedCreateTable;
import io.crate.analyze.BoundCreateTable;
import io.crate.analyze.NumberOfShards;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.ddl.tables.CreateTableClient;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;

public class CreateTablePlan
implements Plan {
    private final AnalyzedCreateTable createTable;
    private final NumberOfShards numberOfShards;
    private final CreateTableClient createTableClient;

    public CreateTablePlan(AnalyzedCreateTable createTable, NumberOfShards numberOfShards, CreateTableClient createTableClient) {
        this.createTable = createTable;
        this.numberOfShards = numberOfShards;
        this.createTableClient = createTableClient;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        BoundCreateTable boundCreateTable = this.createTable.bind(this.numberOfShards, dependencies.fulltextAnalyzerResolver(), plannerContext.nodeContext(), plannerContext.transactionContext(), params, subQueryResults);
        this.createTableClient.create(boundCreateTable, plannerContext.clusterState().nodes().getMinNodeVersion()).whenComplete((rowCount, err) -> {
            if (err == null) {
                consumer.accept(InMemoryBatchIterator.of((Object)new Row1((Object)(rowCount == null ? -1L : rowCount)), null), null);
            } else if (boundCreateTable.ifNotExists() && CreateTableClient.isTableExistsError(err, boundCreateTable.templateName())) {
                consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
            } else {
                consumer.accept(null, err);
            }
        });
    }
}

