/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dql;

import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Collect
implements ExecutionPlan,
ResultDescription {
    private final CollectPhase collectPhase;
    private int unfinishedLimit;
    private int unfinishedOffset;
    private int numOutputs;
    private final int maxRowsPerNode;
    @Nullable
    private PositionalOrderBy orderBy;

    public Collect(CollectPhase collectPhase, int unfinishedLimit, int unfinishedOffset, int numOutputs, int maxRowsPerNode, @Nullable PositionalOrderBy orderBy) {
        this.collectPhase = collectPhase;
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.numOutputs = numOutputs;
        this.maxRowsPerNode = maxRowsPerNode;
        this.orderBy = orderBy;
    }

    public CollectPhase collectPhase() {
        return this.collectPhase;
    }

    @Override
    public <C, R> R accept(ExecutionPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCollect(this, context);
    }

    @Override
    public void addProjection(Projection projection) {
        this.collectPhase.addProjection(projection);
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public void addProjection(Projection projection, int unfinishedLimit, int unfinishedOffset, @Nullable PositionalOrderBy unfinishedOrderBy) {
        this.collectPhase.addProjection(projection);
        this.unfinishedLimit = unfinishedLimit;
        this.unfinishedOffset = unfinishedOffset;
        this.orderBy = unfinishedOrderBy;
        this.numOutputs = projection.outputs().size();
    }

    @Override
    public ResultDescription resultDescription() {
        return this;
    }

    @Override
    public void setDistributionInfo(DistributionInfo distributionInfo) {
        this.collectPhase.distributionInfo(distributionInfo);
    }

    @Override
    public Collection<String> nodeIds() {
        return this.collectPhase.nodeIds();
    }

    @Override
    @Nullable
    public PositionalOrderBy orderBy() {
        return this.orderBy;
    }

    @Override
    public int limit() {
        return this.unfinishedLimit;
    }

    @Override
    public int maxRowsPerNode() {
        return this.maxRowsPerNode;
    }

    @Override
    public int offset() {
        return this.unfinishedOffset;
    }

    @Override
    public int numOutputs() {
        return this.numOutputs;
    }

    @Override
    public boolean executesOnShard() {
        List<Projection> projections = this.collectPhase.projections();
        if (projections.isEmpty()) {
            RoutedCollectPhase routedPhase;
            CollectPhase collectPhase = this.collectPhase;
            return collectPhase instanceof RoutedCollectPhase && (routedPhase = (RoutedCollectPhase)collectPhase).routing().containsShards() && routedPhase.orderBy() == null;
        }
        Projection lastProjection = projections.get(projections.size() - 1);
        return lastProjection.requiredGranularity() == RowGranularity.SHARD;
    }

    @Override
    public List<DataType<?>> streamOutputs() {
        List<Projection> projections = this.collectPhase.projections();
        if (projections.isEmpty()) {
            return Symbols.typeView(this.collectPhase.toCollect());
        }
        Projection lastProjection = projections.get(projections.size() - 1);
        return Symbols.typeView(lastProjection.outputs());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collect collect = (Collect)o;
        return this.unfinishedLimit == collect.unfinishedLimit && this.unfinishedOffset == collect.unfinishedOffset && this.numOutputs == collect.numOutputs && this.maxRowsPerNode == collect.maxRowsPerNode && Objects.equals(this.collectPhase, collect.collectPhase) && Objects.equals(this.orderBy, collect.orderBy);
    }

    public int hashCode() {
        return Objects.hash(this.collectPhase, this.unfinishedLimit, this.unfinishedOffset, this.numOutputs, this.maxRowsPerNode, this.orderBy);
    }
}

