/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.dql;

import io.crate.analyze.WhereClause;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import java.util.List;

public final class GroupByConsumer {
    private GroupByConsumer() {
    }

    public static boolean groupedByClusteredColumnOrPrimaryKeys(DocTableInfo tableInfo, WhereClause whereClause, List<Symbol> groupBySymbols) {
        Reference ref;
        if (groupBySymbols.size() > 1) {
            return GroupByConsumer.groupedByPrimaryKeys(tableInfo.primaryKey(), groupBySymbols);
        }
        if (tableInfo.isPartitioned() && whereClause.partitions().size() != 1) {
            return false;
        }
        Symbol groupByKey = groupBySymbols.get(0);
        return groupByKey instanceof Reference && (ref = (Reference)groupByKey).column().equals(tableInfo.clusteredBy());
    }

    private static boolean groupedByPrimaryKeys(List<ColumnIdent> primaryKeys, List<Symbol> groupBy) {
        if (groupBy.size() != primaryKeys.size()) {
            return false;
        }
        int groupBySize = groupBy.size();
        for (int i = 0; i < groupBySize; ++i) {
            Symbol groupBySymbol = groupBy.get(i);
            if (groupBySymbol instanceof Reference) {
                Reference ref = (Reference)groupBySymbol;
                ColumnIdent columnIdent = ref.column();
                ColumnIdent pkIdent = primaryKeys.get(i);
                if (pkIdent.equals(columnIdent)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

