/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.sql.tree.JoinType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class JoinPlan
extends AbstractJoinPlan {
    private final boolean isFiltered;
    private final boolean rewriteFilterOnOuterJoinToInnerJoinDone;
    private final boolean lookUpJoinRuleApplied;
    private final boolean moveConstantJoinConditionRuleApplied;

    public JoinPlan(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered, boolean rewriteFilterOnOuterJoinToInnerJoinDone, boolean lookUpJoinRuleApplied, AbstractJoinPlan.LookUpJoin lookUpJoin) {
        this(lhs, rhs, joinType, joinCondition, isFiltered, rewriteFilterOnOuterJoinToInnerJoinDone, lookUpJoinRuleApplied, false, lookUpJoin);
    }

    @VisibleForTesting
    public JoinPlan(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition) {
        this(lhs, rhs, joinType, joinCondition, false, false, false, false, AbstractJoinPlan.LookUpJoin.NONE);
    }

    public JoinPlan(LogicalPlan lhs, LogicalPlan rhs, JoinType joinType, @Nullable Symbol joinCondition, boolean isFiltered, boolean rewriteFilterOnOuterJoinToInnerJoinDone, boolean lookUpJoinRuleApplied, boolean moveConstantJoinConditionRuleApplied, AbstractJoinPlan.LookUpJoin lookUpJoin) {
        super(lhs, rhs, joinCondition, joinType, lookUpJoin);
        this.isFiltered = isFiltered;
        this.rewriteFilterOnOuterJoinToInnerJoinDone = rewriteFilterOnOuterJoinToInnerJoinDone;
        this.lookUpJoinRuleApplied = lookUpJoinRuleApplied;
        this.moveConstantJoinConditionRuleApplied = moveConstantJoinConditionRuleApplied;
    }

    public boolean isLookUpJoinRuleApplied() {
        return this.lookUpJoinRuleApplied;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isRewriteFilterOnOuterJoinToInnerJoinDone() {
        return this.rewriteFilterOnOuterJoinToInnerJoinDone;
    }

    public boolean moveConstantJoinConditionRuleApplied() {
        return this.moveConstantJoinConditionRuleApplied;
    }

    public JoinPlan withMoveConstantJoinConditionRuleApplied(boolean moveConstantJoinConditionRuleApplied) {
        return new JoinPlan(this.lhs, this.rhs, this.joinType, this.joinCondition, this.isFiltered, this.rewriteFilterOnOuterJoinToInnerJoinDone, this.lookUpJoinRuleApplied, moveConstantJoinConditionRuleApplied, this.lookupJoin);
    }

    @Override
    public ExecutionPlan build(DependencyCarrier dependencyCarrier, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        throw new UnsupportedOperationException("JoinPlan cannot be build, it needs to be converted to a NestedLoop/HashJoin");
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitJoinPlan(this, context);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> lhsToKeep = new LinkedHashSet<Symbol>();
        LinkedHashSet<Symbol> rhsToKeep = new LinkedHashSet<Symbol>();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.lhs.outputs(), lhsToKeep::add);
            Symbols.intersection(outputToKeep, this.rhs.outputs(), rhsToKeep::add);
        }
        if (this.joinCondition != null) {
            Symbols.intersection(this.joinCondition, this.lhs.outputs(), lhsToKeep::add);
            Symbols.intersection(this.joinCondition, this.rhs.outputs(), rhsToKeep::add);
        }
        LogicalPlan newLhs = this.lhs.pruneOutputsExcept(lhsToKeep);
        LogicalPlan newRhs = this.rhs.pruneOutputsExcept(rhsToKeep);
        if (newLhs == this.lhs && newRhs == this.rhs) {
            return this;
        }
        return new JoinPlan(newLhs, newRhs, this.joinType, this.joinCondition, this.isFiltered, this.rewriteFilterOnOuterJoinToInnerJoinDone, this.lookUpJoinRuleApplied, this.moveConstantJoinConditionRuleApplied, this.lookupJoin);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Join[").text(this.joinType.toString());
        if (this.joinCondition != null) {
            printContext.text(" | ").text(this.joinCondition.toString());
        }
        printContext.text("]");
        this.printStats(printContext);
        printContext.nest(Lists.map(this.sources(), x -> x::print));
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new JoinPlan(sources.get(0), sources.get(1), this.joinType, this.joinCondition, this.isFiltered, this.rewriteFilterOnOuterJoinToInnerJoinDone, this.lookUpJoinRuleApplied, this.moveConstantJoinConditionRuleApplied, this.lookupJoin);
    }
}

