/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.data.Row;
import io.crate.exceptions.ConversionException;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.ParameterSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.function.UnaryOperator;

public class SubQueryAndParamBinder
extends FunctionCopyVisitor<Void>
implements UnaryOperator<Symbol> {
    private final Row params;
    private final SubQueryResults subQueryResults;

    public static Symbol convert(Symbol symbol, Row params, SubQueryResults subQueryResults) {
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        return binder.apply(symbol);
    }

    public SubQueryAndParamBinder(Row params, SubQueryResults subQueryResults) {
        this.params = params;
        this.subQueryResults = subQueryResults;
    }

    @Override
    public Symbol visitParameterSymbol(ParameterSymbol parameterSymbol, Void context) {
        return SubQueryAndParamBinder.convert(parameterSymbol, this.params);
    }

    @Override
    public Symbol visitSelectSymbol(SelectSymbol selectSymbol, Void context) {
        DataType<?> valueType = selectSymbol.valueType();
        if (selectSymbol.isCorrelated()) {
            return selectSymbol;
        }
        Object value = this.subQueryResults.getSafe(selectSymbol);
        return Literal.ofUnchecked(valueType, valueType.sanitizeValue(value));
    }

    @Override
    public Symbol visitOuterColumn(OuterColumn outerColumn, Void context) {
        DataType<?> valueType = outerColumn.valueType();
        Object value = this.subQueryResults.get(outerColumn);
        return Literal.ofUnchecked(valueType, valueType.sanitizeValue(value));
    }

    @Override
    public Symbol apply(Symbol symbol) {
        return symbol.accept(this, null);
    }

    private static Symbol convert(ParameterSymbol parameterSymbol, Row params) {
        Object value = parameterSymbol.bind(params);
        DataType<?> type = parameterSymbol.valueType();
        if (type.equals(DataTypes.UNDEFINED)) {
            type = DataTypes.guessType(value);
        }
        try {
            return Literal.ofUnchecked(type, type.implicitCast(value));
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ConversionException(value, type);
        }
    }
}

