/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.iterative;

import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Optimizer;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.iterative.GroupReference;
import io.crate.planner.optimizer.iterative.Memo;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import io.crate.session.Session;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.Version;

public class IterativeOptimizer {
    private final List<Rule<?>> rules;
    private final Supplier<Version> minNodeVersionInCluster;
    private final NodeContext nodeCtx;

    public IterativeOptimizer(NodeContext nodeCtx, Supplier<Version> minNodeVersionInCluster, List<Rule<?>> rules) {
        this.rules = rules;
        this.minNodeVersionInCluster = minNodeVersionInCluster;
        this.nodeCtx = nodeCtx;
    }

    public LogicalPlan optimize(LogicalPlan plan, PlanStats planStats, CoordinatorTxnCtx txnCtx, OptimizerTracer tracer, Session.TimeoutToken timeoutToken) {
        Memo memo = new Memo(plan);
        PlanStats planStatsWithMemo = planStats.withMemo(memo);
        UnaryOperator groupReferenceResolver = node -> {
            if (node instanceof GroupReference) {
                GroupReference g = (GroupReference)node;
                return memo.resolve(g.groupId());
            }
            return node;
        };
        tracer.optimizationStarted(plan, planStatsWithMemo);
        List<Rule<?>> applicableRules = Optimizer.removeExcludedRules(this.rules, txnCtx.sessionSettings().excludedOptimizerRules());
        this.exploreGroup(memo.getRootGroup(), new Context(memo, groupReferenceResolver, applicableRules, txnCtx, planStatsWithMemo, tracer, timeoutToken));
        return memo.extract();
    }

    private boolean exploreGroup(int group, Context context) {
        boolean progress = this.exploreNode(group, context);
        while (this.exploreChildren(group, context)) {
            progress = true;
            if (this.exploreNode(group, context)) continue;
            break;
        }
        return progress;
    }

    private boolean exploreNode(int group, Context context) {
        List<Rule<?>> rules = context.rules;
        LogicalPlan node = context.memo.resolve(group);
        Rule.Context ruleContext = new Rule.Context(context.planStats, context.txnCtx, this.nodeCtx, context.groupReferenceResolver, context.timeoutToken);
        int numIteration = 0;
        int maxIterations = 10000;
        boolean progress = false;
        boolean done = false;
        Version minVersion = this.minNodeVersionInCluster.get();
        while (!done && numIteration < maxIterations) {
            Session.TimeoutToken timeoutToken = context.timeoutToken;
            if (++numIteration % 100 == 0) {
                timeoutToken.check();
            }
            done = true;
            for (Rule<?> rule : rules) {
                LogicalPlan transformed;
                if (minVersion.before(rule.requiredVersion()) || (transformed = Optimizer.tryMatchAndApply(rule, node, ruleContext, context.tracer)) == null) continue;
                context.memo.replace(group, transformed);
                node = transformed;
                done = false;
                progress = true;
                OptimizerTracer tracer = context.tracer;
                if (!tracer.isActive()) continue;
                tracer.ruleApplied(rule, context.memo.extract(), context.planStats);
            }
        }
        assert (numIteration < maxIterations) : "Optimizer reached 10_000 iterations safety guard. This is an indication of a broken rule that matches again and again";
        return progress;
    }

    private boolean exploreChildren(int group, Context context) {
        boolean progress = false;
        LogicalPlan expression = context.memo.resolve(group);
        for (LogicalPlan child : expression.sources()) {
            if (child instanceof GroupReference) {
                GroupReference g = (GroupReference)child;
                if (!this.exploreGroup(g.groupId(), context)) continue;
                progress = true;
                continue;
            }
            throw new IllegalStateException("Expected child to be a group reference. Found: " + child.getClass().getName());
        }
        return progress;
    }

    private record Context(Memo memo, UnaryOperator<LogicalPlan> groupReferenceResolver, List<Rule<?>> rules, CoordinatorTxnCtx txnCtx, PlanStats planStats, OptimizerTracer tracer, Session.TimeoutToken timeoutToken) {
    }
}

